package com.elitesland.tw.tw5.server.common.log.entity;


import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 通用日志信息表
 *
 * @author carl
 */

@Entity
@Table(name = "com_log")
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@org.hibernate.annotations.Table(appliesTo = "com_log", comment = "通用日志信息表")
@Where(clause = "delete_flag= 0")
public class ComLogDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 1L;

    @Comment("对象id")
    @Column(name = "object_id", nullable = false)
    private String objectId;

    @Comment("跟进对象")
    @Column(name = "log_type", nullable = false)
    private String logType;

    @Comment("日志内容")
    @Column(name = "log_content", nullable = false)
    private String logContent;
    
    @Column()
    @Comment("版本号")
    private Integer versionNo;

    private String extString1;
    private String extString2;
    private String extString3;
    private String extString4;
    private String extString5;
}

