package com.elitesland.tw.tw5.server.common.workFlow;

import com.elitesland.tw.tw5.api.common.TwException;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.payload.DeleteProcessPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Component
@RequiredArgsConstructor
@Slf4j
public class WorkflowUtil {
    private final WorkflowService workflowService;

    /**
     * 创建工作流
     *
     * @param payload
     * @return
     */
    public ProcessInfo startProcess(StartProcessPayload payload) {
        WorkflowResult<ProcessInfo> workflowResult = workflowService.startProcess(payload);
        System.out.println("workflowResult:::" + workflowResult.toString());
        if (workflowResult != null) {
            if (workflowResult.isSuccess()) {
                return workflowResult.getData();
            } else {
                throw TwException.error("", "工作流创建异常:" + workflowResult.getMsg());
            }
        } else {
            throw TwException.error("", "工作流创建返回值异常，请联系管理员！");
        }

    }

    /**
     * 删除工作流
     *
     * @param payload
     */
    public void deleteProcess(DeleteProcessPayload payload) {
        WorkflowResult workflowResult = workflowService.deleteProcess(payload);
        if (workflowResult != null) {
            if (!workflowResult.isSuccess()) {
                throw TwException.error("", workflowResult.getMsg());
            }
        } else {
            throw TwException.error("", "工作流删除异常，请联系管理员！");
        }
    }
}
