package com.elitesland.tw.tw5.server.demo.leave.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwOutputUtil;
import com.elitesland.tw.tw5.api.demo.leave.payload.DemoLeavePayload;
import com.elitesland.tw.tw5.api.demo.leave.query.DemoLeaveQuery;
import com.elitesland.tw.tw5.api.demo.leave.service.DemoLeaveService;
import com.elitesland.tw.tw5.api.demo.leave.vo.DemoLeaveVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * common/demo/请假demo
 *
 * @author zhangyongqiang
 */
@Api(tags = "demo")
@RestController
@RequiredArgsConstructor
@RequestMapping(value = "/api/demo")
@Slf4j
public class DemoLeaveController {

    private final DemoLeaveService service;

    /**
     * 新建
     * @param payload payload
     * @return result
     */
    @ApiOperation("新建")
    @PostMapping("/leave")
    public TwOutputUtil<DemoLeaveVO> insert(DemoLeavePayload payload) {
        return service.insert(payload);
    }

    /**
     * 全部修改
     * @param payload payload
     * @return result
     */
    @ApiOperation("全部修改")
    @PutMapping("/leave")
    public TwOutputUtil<DemoLeaveVO> update(DemoLeavePayload payload) {
        return service.update(payload);
    }

    /**
     * 动态修改（仅修改属性不为null的字段，如果需要将字段设置为null，请设置 `nullFields` 属性）
     * @param payload payload
     * @return result
     */
    @ApiOperation("动态修改（仅修改属性不为null的字段，如果需要将字段设置为null，请设置 `nullFields` 属性）")
    @PutMapping("/leave/updateDynamic")
    public TwOutputUtil<DemoLeaveVO> updateDynamic(DemoLeavePayload payload) {
        return service.updateDynamic(payload);
    }

    /**
     * 主键查询
     * @param key key
     * @return result
     */
    @ApiOperation("主键查询")
    @GetMapping("/leave/{key}")
    public TwOutputUtil<DemoLeaveVO> queryOneByKey(@PathVariable Long key) {
        return service.queryByKey(key);
    }

    /**
     * 分页查询
     * @param query query
     * @return result
     */
    @ApiOperation("分页查询")
    @GetMapping("/leave/paging")
    public TwOutputUtil<PagingVO<DemoLeaveVO>> paging(DemoLeaveQuery query) {
        return service.paging(query);
    }

    /**
     * 列表查询
     * @param query query
     * @return result
     */
    @ApiOperation("列表查询")
    @GetMapping("/leave/list")
    public TwOutputUtil<List<DemoLeaveVO>> queryList(DemoLeaveQuery query) {
        return service.queryList(query);
    }

    /**
     * 删除
     * @param keys keys
     * @return result
     */
    @ApiOperation("删除")
    @PatchMapping("/leave")
    public TwOutputUtil<List<Long>> deleteSoft(Long[] keys) {
        return service.deleteSoft(Arrays.asList(keys));
    }

}
