package com.elitesland.tw.tw5.server.demo.leave.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.demo.leave.payload.DemoLeavePayload;
import com.elitesland.tw.tw5.api.demo.leave.query.DemoLeaveQuery;
import com.elitesland.tw.tw5.api.demo.leave.vo.DemoLeaveVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.demo.leave.entity.QDemoLeaveDO;
import com.elitesland.tw.tw5.server.demo.leave.repo.DemoLeaveRepo;
import com.elitesland.tw.tw5.server.demo.leave.entity.DemoLeaveDO;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.List;

/**
 * 学生dao
 *
 * @author zhangyongqiang
 */
@Repository
@RequiredArgsConstructor
public class DemoLeaveDAO {

    private final JPAQueryFactory jpaQueryFactory;

    private final DemoLeaveRepo repo;
    private final QDemoLeaveDO qdo = QDemoLeaveDO.demoLeaveDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<DemoLeaveVO> getJpaQuerySelect() {
        QBean<DemoLeaveVO> qBean = Projections.bean(DemoLeaveVO.class,
                qdo.id,
                qdo.leaveNo,
                qdo.leaveName,
                qdo.userId,
                qdo.orgId,
                qdo.ouId,
                qdo.days,
                qdo.startDate,
                qdo.endDate,
                qdo.fileCodes,
                qdo.ext1, qdo.ext2, qdo.ext3, qdo.ext4, qdo.ext5, qdo.ext6, qdo.ext7, qdo.ext8, qdo.ext9, qdo.ext10,
                qdo.createUserId,
                qdo.createTime,
                qdo.deleteFlag
        );
        return jpaQueryFactory.select(qBean).from(qdo);

    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<DemoLeaveVO> getJpaQueryWhere(DemoLeaveQuery query) {
        JPAQuery<DemoLeaveVO> jpaQuery = getJpaQuerySelect();

        if (!ObjectUtils.isEmpty(query.getLeaveNo())) {
            jpaQuery.where(qdo.leaveNo.like(SqlUtil.toSqlLikeString(query.getLeaveNo())));
        }
        if (!ObjectUtils.isEmpty(query.getLeaveName())) {
            jpaQuery.where(qdo.leaveName.like(SqlUtil.toSqlLikeString(query.getLeaveName())));
        }
        if (!ObjectUtils.isEmpty(query.getUserId())) {
            jpaQuery.where(qdo.userId.eq(query.getUserId()));
        }
        if (!ObjectUtils.isEmpty(query.getOrgId())) {
            jpaQuery.where(qdo.orgId.eq(query.getOrgId()));
        }
        if (!ObjectUtils.isEmpty(query.getOuId())) {
            jpaQuery.where(qdo.ouId.eq(query.getOuId()));
        }
        if (!ObjectUtils.isEmpty(query.getDays())) {
            jpaQuery.where(qdo.days.eq(query.getDays()));
        }
        if (!ObjectUtils.isEmpty(query.getStartDate())) {
            jpaQuery.where(qdo.startDate.eq(query.getStartDate()));
        }
        if (!ObjectUtils.isEmpty(query.getEndDate())) {
            jpaQuery.where(qdo.endDate.eq(query.getEndDate()));
        }
        if (!ObjectUtils.isEmpty(query.getEndDate())) {
            jpaQuery.where(qdo.endDate.eq(query.getEndDate()));
        }
        if (!ObjectUtils.isEmpty(query.getExt1())) {
            jpaQuery.where(qdo.ext1.like(SqlUtil.toSqlLikeString(query.getExt1())));
        }
        if (!ObjectUtils.isEmpty(query.getExt2())) {
            jpaQuery.where(qdo.ext2.like(SqlUtil.toSqlLikeString(query.getExt2())));
        }
        if (!ObjectUtils.isEmpty(query.getExt3())) {
            jpaQuery.where(qdo.ext3.like(SqlUtil.toSqlLikeString(query.getExt3())));
        }
        if (!ObjectUtils.isEmpty(query.getExt4())) {
            jpaQuery.where(qdo.ext4.like(SqlUtil.toSqlLikeString(query.getExt4())));
        }
        if (!ObjectUtils.isEmpty(query.getExt5())) {
            jpaQuery.where(qdo.ext5.like(SqlUtil.toSqlLikeString(query.getExt5())));
        }
        if (!ObjectUtils.isEmpty(query.getExt6())) {
            jpaQuery.where(qdo.ext6.like(SqlUtil.toSqlLikeString(query.getExt6())));
        }
        if (!ObjectUtils.isEmpty(query.getExt7())) {
            jpaQuery.where(qdo.ext7.like(SqlUtil.toSqlLikeString(query.getExt7())));
        }
        if (!ObjectUtils.isEmpty(query.getExt8())) {
            jpaQuery.where(qdo.ext8.like(SqlUtil.toSqlLikeString(query.getExt8())));
        }
        if (!ObjectUtils.isEmpty(query.getExt9())) {
            jpaQuery.where(qdo.ext9.like(SqlUtil.toSqlLikeString(query.getExt9())));
        }
        if (!ObjectUtils.isEmpty(query.getExt10())) {
            jpaQuery.where(qdo.ext10.like(SqlUtil.toSqlLikeString(query.getExt10())));
        }

        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(query.getOrders(), qdo));
        return jpaQuery;
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public DemoLeaveVO queryByKey(Long id) {
        JPAQuery<DemoLeaveVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 根据主键查询
     *
     * @param ids 主键
     * @return 结果
     */
    public List<DemoLeaveVO> queryByKeys(List<Long> ids) {
        JPAQuery<DemoLeaveVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.in(ids));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<DemoLeaveVO> queryListDynamic(DemoLeaveQuery query) {
        JPAQuery<DemoLeaveVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<DemoLeaveVO> queryPaging(DemoLeaveQuery query) {
        JPAQuery<DemoLeaveVO> jpaQuery = getJpaQueryWhere(query);
        QueryResults<DemoLeaveVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<DemoLeaveVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }


    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public DemoLeaveDO save(DemoLeaveDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<DemoLeaveDO> saveAll(List<DemoLeaveDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(DemoLeavePayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));

        if (payload.getLeaveNo() != null) {
            update.set(qdo.leaveNo, payload.getLeaveNo());
        }
        if (payload.getLeaveName() != null) {
            update.set(qdo.leaveName, payload.getLeaveName());
        }
        if (payload.getUserId() != null) {
            update.set(qdo.userId, payload.getUserId());
        }
        if (payload.getOrgId() != null) {
            update.set(qdo.orgId, payload.getOrgId());
        }
        if (payload.getOuId() != null) {
            update.set(qdo.ouId, payload.getOuId());
        }
        if (payload.getDays() != null) {
            update.set(qdo.days, payload.getDays());
        }
        if (payload.getStartDate() != null) {
            update.set(qdo.startDate, payload.getStartDate());
        }
        if (payload.getEndDate() != null) {
            update.set(qdo.endDate, payload.getEndDate());
        }
        if (payload.getExt1() != null) {
            update.set(qdo.ext1, payload.getExt1());
        }
        if (payload.getExt2() != null) {
            update.set(qdo.ext2, payload.getExt2());
        }
        if (payload.getExt3() != null) {
            update.set(qdo.ext3, payload.getExt3());
        }
        if (payload.getExt4() != null) {
            update.set(qdo.ext4, payload.getExt4());
        }
        if (payload.getExt5() != null) {
            update.set(qdo.ext5, payload.getExt5());
        }
        if (payload.getExt6() != null) {
            update.set(qdo.ext6, payload.getExt6());
        }
        if (payload.getExt7() != null) {
            update.set(qdo.ext7, payload.getExt7());
        }
        if (payload.getExt8() != null) {
            update.set(qdo.ext8, payload.getExt8());
        }
        if (payload.getExt9() != null) {
            update.set(qdo.ext9, payload.getExt9());
        }
        if (payload.getExt10() != null) {
            update.set(qdo.ext10, payload.getExt10());
        }

        // 处理要设置成空的字段
        SqlUtil.handleNullFieldsUpdate(payload.getNullFields(), qdo, update);

        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        return update.execute();
    }


}
