package com.elitesland.tw.tw5.server.demo.leave.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDate;

/**
 * 请假DO
 * @author zhangyongqiang
 */
// 指定数据库是哪个表
@Entity(name = "demo_leave")
@Table(name = "demo_leave")
// 为表增加注释字段
@org.hibernate.annotations.Table(appliesTo = "demo_leave", comment = "请假表")
@Getter
@Setter
@Where(clause = " delete_flag = 0 ")
public class DemoLeaveDO extends BaseModel implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    @Comment("编号")
    @Column()
    private String leaveNo;

    @Comment("名称")
    @Column()
    private String leaveName;

    @Comment("请假人userId")
    @Column()
    private Long  userId;

    @Comment("请假人组织Id")
    @Column()
    private Long  orgId;

    @Comment("请假人所属公司Id")
    @Column()
    private Long  ouId;

    @Comment("天数")
    @Column()
    private Integer days;


    @Comment("开始日期")
    @Column()
    private LocalDate startDate;

    @Comment("结束日期")
    @Column()
    private LocalDate endDate;

    @Comment("附件")
    @Column(length = 500)
    private String fileCodes;

    @Comment("拓展字段1")
    @Column()
    private String ext1;
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    @Comment("拓展字段3")
    @Column()
    private String ext3;
    @Comment("拓展字段4")
    @Column()
    private String ext4;
    @Comment("拓展字段5")
    @Column()
    private String ext5;
    @Comment("拓展字段6")
    @Column()
    private String ext6;
    @Comment("拓展字段7")
    @Column()
    private String ext7;
    @Comment("拓展字段8")
    @Column()
    private String ext8;
    @Comment("拓展字段9")
    @Column()
    private String ext9;
    @Comment("拓展字段10")
    @Column()
    private String ext10;


}
