package com.elitesland.tw.tw5.server.demo.leave.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwOutputUtil;
import com.elitesland.tw.tw5.api.demo.leave.payload.DemoLeavePayload;
import com.elitesland.tw.tw5.api.demo.leave.query.DemoLeaveQuery;
import com.elitesland.tw.tw5.api.demo.leave.service.DemoLeaveService;
import com.elitesland.tw.tw5.api.demo.leave.vo.DemoLeaveVO;
import com.elitesland.tw.tw5.server.demo.leave.convert.DemoLeaveConvert;
import com.elitesland.tw.tw5.server.demo.leave.dao.DemoLeaveDAO;
import com.elitesland.tw.tw5.server.demo.leave.entity.DemoLeaveDO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.List;

/**
 * 请假service
 *
 * @author zhangyongqiang
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class DemoLeaveServiceImpl implements DemoLeaveService {

    private final DemoLeaveDAO dao;

//    private final CacheUtil cacheUtil;
//    private final WorkflowUtil workflowUtil;

    /**
     * 单据业务检查
     * @param payload 入参
     * @return result
     */
    public TwOutputUtil<DemoLeaveVO> businessCheck(DemoLeavePayload payload) {
        // 业务检查
        if(ObjectUtils.isEmpty(payload.getLeaveNo())){
            return TwOutputUtil.error("","编号不能为空");
        }

        return TwOutputUtil.ok();
    }

    private void transformData(DemoLeaveVO vo){
        // 处理数据翻译
        vo.setCreator("张三");
    }

    @Transactional
    @Override
    public TwOutputUtil<DemoLeaveVO> insert(DemoLeavePayload payload) {
        // 业务检查
        TwOutputUtil<DemoLeaveVO> checkResult = businessCheck(payload);
        if(!checkResult.isOk()){
            return checkResult;
        }

        DemoLeaveDO ado = DemoLeaveConvert.INSTANCE.toDo(payload);
        dao.save(ado);
        DemoLeaveVO demoLeaveVO = DemoLeaveConvert.INSTANCE.toVo(ado);

        return TwOutputUtil.ok(demoLeaveVO);
    }

    @Override
    public TwOutputUtil<DemoLeaveVO> update(DemoLeavePayload payload) {
        // 业务检查
        TwOutputUtil<DemoLeaveVO> checkResult = businessCheck(payload);
        if(!checkResult.isOk()){
            return checkResult;
        }

        DemoLeaveDO ado = DemoLeaveConvert.INSTANCE.toDo(payload);
        dao.save(ado);
        DemoLeaveVO vo = DemoLeaveConvert.INSTANCE.toVo(ado);
        return TwOutputUtil.ok(vo);
    }

    @Override
    public TwOutputUtil<DemoLeaveVO> updateDynamic(DemoLeavePayload payload) {
        // 业务检查
        TwOutputUtil<DemoLeaveVO> checkResult = businessCheck(payload);
        if(!checkResult.isOk()){
            return checkResult;
        }
        dao.updateByKeyDynamic(payload);
        DemoLeaveVO vo = DemoLeaveConvert.INSTANCE.toVo(payload);
        return TwOutputUtil.ok(vo);
    }

    @Override
    public TwOutputUtil<DemoLeaveVO> queryByKey(Long key) {
        DemoLeaveVO vo = dao.queryByKey(key);
        return TwOutputUtil.ok(vo);
    }

    @Override
    public TwOutputUtil<PagingVO<DemoLeaveVO>> paging(DemoLeaveQuery query) {
        PagingVO<DemoLeaveVO> demoLeaveVOPagingVO = dao.queryPaging(query);
        List<DemoLeaveVO> records = demoLeaveVOPagingVO.getRecords();
        records.forEach(this::transformData);
        return TwOutputUtil.ok(demoLeaveVOPagingVO);
    }


    @Override
    public TwOutputUtil<List<DemoLeaveVO>> queryList(DemoLeaveQuery query) {
        List<DemoLeaveVO> vos = dao.queryListDynamic(query);
        return TwOutputUtil.ok(vos);
    }

    @Transactional
    @Override
    public TwOutputUtil<List<Long>> deleteSoft(List<Long> keys) {
        // 删除业务检查
        List<DemoLeaveVO> demoLeaveVOS = dao.queryByKeys(keys);
        if (CollectionUtils.isEmpty(demoLeaveVOS)) {
            return TwOutputUtil.error("", "不存在要删除的数据");
        }
        // 执行删除
        dao.deleteSoft(keys);
        return TwOutputUtil.ok(keys);
    }

}
