package com.elitesland.tw.tw5.server.log.controller;

import com.elitesland.tw.tw5.api.log.query.LogQuery;
import com.elitesland.tw.tw5.api.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.log.service.LogService;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
* 日志记录
*
* @author duwh
* @date 2023-02-03
*/
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/common/log")
@Slf4j
public class LogController {

    private final LogService logService;

    /**
    * 主键查询
    *
    * @param key 关键
    * @return {@link TwOutputUtil}
    */
    @GetMapping("/{key}")
    // @UdcNameClass
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(logService.queryByKey(key));
    }

    /**
    * 分页
    *
    * @param query 查询
    * @return {@link TwOutputUtil}
    */
    @GetMapping("/paging")
    // @UdcNameClass
    public TwOutputUtil paging(LogQuery query) {
        return TwOutputUtil.ok(logService.paging(query));
    }

    /**
    * 查询列表
    *
    * @param query 查询
    * @return {@link TwOutputUtil}
    */
    @GetMapping("/list")
    // @UdcNameClass
    public TwOutputUtil queryList(LogQuery query) {
        return TwOutputUtil.ok(logService.queryList(query));
    }

    /**
    * 删除
    *
    * @param keys 主键id
    * @return result
    */
    @DeleteMapping("/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys) {
        logService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 物理删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/log/delete")
    public TwOutputUtil delete(Long[] keys) {
        final boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
        if (isSystemAdmin) {
            logService.delete(Arrays.asList(keys));
        }
        return TwOutputUtil.ok();
    }

}
