package com.elitesland.tw.tw5.server.prd.ab.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @author carl.wang
 * @Description:账户表
 */
@Entity
@Table(name = "prd_ab_account", indexes = {
        @Index(name = "book_index", columnList = "book_id"),
})
@org.hibernate.annotations.Table(appliesTo = "prd_ab_account", comment = "账户表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdAbAccountDO extends BaseModel {

    @Comment("地址簿id")
    @Column(name = "book_id")
    private Long bookId;

    @Comment("tw4.0账户表ID")
    @Column(name = "account_id_v4")
    private Long accountIdV4;

    @Comment("账户类型")
    @Column(name = "account_type")
    private String accountType;

    @Comment("银行")
    @Column(name = "deposit_bank")
    private String depositBank;

    @Comment("开户地")
    @Column(name = "deposit_city")
    private String depositCity;

    @Comment("开户网点")
    @Column(name = "deposit_bank_outlet")
    private String depositBankOutlet;

    @Comment("户名")
    @Column(name = "account_name")
    private String accountName;

    @Comment("账号")
    @Column(name = "account_no")
    private String accountNo;

    @Comment("币种")
    @Column(name = "currency")
    private String currency;

    @Comment("默认")
    @Column(name = "is_default")
    private Boolean defaultFlag;
}
