package com.elitesland.tw.tw5.server.prd.ab.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @author carl.wang
 * @Description:地址簿表
 * @date 2022/6/20
 */
@Entity
@Table(name = "prd_ab")
@org.hibernate.annotations.Table(appliesTo = "prd_ab", comment = "地址簿表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdAbDO extends BaseModel {

    @Comment("地址簿编号")
    @Column()
    private String bookNo;

    @Comment("tw4.0地址薄ID")
    @Column(name = "book_id_v4")
    private Long bookIdV4;

    @Comment("地址簿名称")
    @Column()
    private String bookName;

    @Comment("地址簿类型(公司，个人)")
    @Column()
    private String bookType;

    @Comment("关系类型(内部公司，客户，供应商，合作伙伴)")
    @Column()
    private String relateType;

}
