package com.elitesland.tw.tw5.server.prd.ab.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.common.TwException;
import com.elitesland.tw.tw5.api.prd.ab.payload.PrdAbContactsPayload;
import com.elitesland.tw.tw5.api.prd.ab.query.PrdAbContactsQuery;
import com.elitesland.tw.tw5.api.prd.ab.service.PrdAbContactsService;
import com.elitesland.tw.tw5.api.prd.ab.vo.PrdAbContactsVO;
//import com.elitesland.tw.tw5.api.prd.crm.payload.CrmFollowPayload;
//import com.elitesland.tw.tw5.api.prd.crm.service.CrmFollowService;
//import com.elitesland.tw.tw5.api.prd.crm.vo.CrmFollowVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemLogQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.service.TransferUtilServiceImpl;
import com.elitesland.tw.tw5.server.prd.ab.convert.PrdAbContactsConvert;
import com.elitesland.tw.tw5.server.prd.ab.dao.PrdAbContactsDAO;
import com.elitesland.tw.tw5.server.prd.ab.entity.PrdAbContactsDO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.*;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.List;

/**
 * @Author carl.wang
 * @Description 联系人管理
 **/
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdAbContactsServiceImpl extends BaseServiceImpl implements PrdAbContactsService {
    private final CacheUtil cacheUtil;
    private final PrdAbContactsDAO dao;
//    private final CrmFollowService followService;
    // @DubboReference(version = "${provider.service.version}")
//    @Autowired
//    //private SysNumberRuleService numberRuleService;
    private final PrdSystemLogService logService;
    private final ExcelUtil excelUtil;
    private final TransferUtilServiceImpl transferUtilService;
    private final HttpUtil httpUtil;

    @Value("${tw4.contacts.operation}")
    private String contacts_operation;

    @Value("${tw4.contacts.del}")
    private String contacts_del;

    @Transactional
    @Override
    public PrdAbContactsVO insert(PrdAbContactsPayload payload) {
        String code = generateSeqNum("CONTACTS_NO");
        PrdAbContactsDO contactsDO = PrdAbContactsConvert.INSTANCE.toDo(payload);
        contactsDO.setContactsNo(code);
        contactsDO.setContactsStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());

        //同步到4.0
        //Map<String, Object> map = transferUtilService.beanToMap(contactsDO);
        //String result = httpUtil.sendSyncPost(contacts_operation, map);
        //String contactsId = httpUtil.geResultData(result);
        //long contactsIdV4 = 0;
        //if (StringUtils.hasText(contactsId)) {
        //    if (StringUtil.isInteger(contactsId)) {
        //        contactsIdV4 = Long.valueOf(contactsId);
        //    }
        //}
        //contactsDO.setContactsIdV4(contactsIdV4);
        contactsDO = dao.save(contactsDO);
        saveBaseLog(payload.getBookId(), payload.getObjectType(), PrdSystemLogEnum.CREATE.getDesc());
        saveLog(contactsDO.getId(), PrdSystemObjectEnum.Contacts.getCode(), PrdSystemLogEnum.CREATE.getDesc() + PrdSystemObjectEnum.Contacts.getDesc());
        return PrdAbContactsConvert.INSTANCE.toVo(contactsDO);
    }

    /**
     * 保存基础日志
     *
     * @param bookId     地址簿id
     * @param objectType 主档类型
     * @param logType    记录内容
     */
    void saveBaseLog(Long bookId, String objectType, String logType) {
//        Long customerId = dao.queryIdByBookId(bookId);
//        logService.saveNewLog(customerId, objectType, logType + "联系人");

    }

    /**
     * 保存日志
     *
     * @param id         主键
     * @param objectType 主档类型
     * @param logType    记录内容
     */
    void saveLog(Long id, String objectType, String logType) {
        logService.saveNewLog(id, objectType, logType);

    }

    @Transactional
    @Override
    public boolean delete(Long bookId, String objectType, List<Long> keys) {
        //同步到4.0
        //Map<String, Object> map = new HashMap<>();
        //map.put("ids", org.apache.commons.lang3.StringUtils.join(dao.queryTW4IdsByIds(keys), ","));
        //String result = httpUtil.sendSyncGet(contacts_del, map);
        //httpUtil.geResultData(result);

        dao.delete(keys);
        saveBaseLog(bookId, objectType, PrdSystemLogEnum.DELETE.getDesc());
        return true;
    }

    @Transactional
    @Override
    public boolean update(PrdAbContactsPayload payload) {


        PrdAbContactsVO contactsVO = dao.queryByKey(payload.getId());
        if (contactsVO != null && contactsVO.getContactsStatus().equals(WorkFlowStatusEnum.APPROVED_WORK.getCode())) {
            //同步到4.0
            //Map<String, Object> map = transferUtilService.beanToMap(payload);
            //map.put("id", dao.queryTW4IdById(payload.getId()));
            //String result = httpUtil.sendSyncPost(contacts_operation, map);
            //httpUtil.geResultData(result);

            dao.updateByKeyDynamic(payload);
            saveBaseLog(payload.getBookId(), payload.getObjectType(), PrdSystemLogEnum.UPDATE.getDesc());
            saveLog(payload.getId(), PrdSystemObjectEnum.Contacts.getCode(), PrdSystemLogEnum.UPDATE.getDesc() + PrdSystemObjectEnum.Contacts.getDesc());
        } else {
            throw TwException.error("", "该数据已暂挂");
        }
        return true;
    }

    @Transactional
    @Override
    public boolean updateStatus(Long key, String status) {
        //同步到4.0
        //Map<String, Object> map = new HashMap<>();
        //map.put("id", dao.queryTW4IdById(key));
        //map.put("contactsStatus", status);
        //String result = httpUtil.sendSyncPost(contacts_operation, map);
        //httpUtil.geResultData(result);

        dao.updateStatus(key, status);
        logService.saveNewLog(key, PrdSystemObjectEnum.Contacts.getCode(), cacheUtil.transferSystemSelection(FunctionSelectionEnum.SystemStatus.getCode(), status) + PrdSystemObjectEnum.Contacts.getDesc());
        return true;
    }

    @Override
    public List<PrdAbContactsVO> queryList(Long bookId) {
        List<PrdAbContactsVO> contactsVOS = dao.queryList(bookId);
        contactsVOS.forEach(contactsVO -> transferSystemSelection(contactsVO));
        return contactsVOS;
    }

    @Override
    public PagingVO<PrdAbContactsVO> paging(PrdAbContactsQuery query) {
        PagingVO<PrdAbContactsVO> contactsPagingVOs = dao.queryPaging(query);
        List<PrdAbContactsVO> contactsVOS = contactsPagingVOs.getRecords();
        contactsVOS.forEach(contactsVO -> transferSystemSelection(contactsVO));
        return contactsPagingVOs;
    }

    @Override
    public PrdAbContactsVO queryByKey(Long key) {
        PrdAbContactsVO contactsVO = dao.queryByKey(key);
        transferSystemSelection(contactsVO);
        return contactsVO;
    }

//    @Override
//    public void addFollow(CrmFollowPayload payload) {
//        PrdAbContactsVO contactsVO = dao.queryByKey(payload.getObjectId());
//        if (contactsVO != null && contactsVO.getContactsStatus().equals(WorkFlowStatusEnum.APPROVED_WORK.getCode())) {
//            payload.setFollowObject(CrmFollowObjectEnum.Contacts.getCode());
//            followService.addFollow(payload);
//            saveLog(payload.getObjectId(), PrdSystemObjectEnum.Contacts.getCode(), PrdSystemLogEnum.ADD.getDesc() + PrdSystemLogEnum.FOLLOW.getDesc());
//        } else {
//            throw TwException.error("", "该数据已暂挂");
//        }
//    }
//
//    @Override
//    public void updateFollow(CrmFollowPayload payload) {
//        PrdAbContactsVO contactsVO = dao.queryByKey(payload.getObjectId());
//        if (contactsVO != null && contactsVO.getContactsStatus().equals(WorkFlowStatusEnum.APPROVED_WORK.getCode())) {
//            payload.setFollowObject(CrmFollowObjectEnum.Contacts.getCode());
//            followService.updateFollow(payload);
//            saveLog(payload.getId(), PrdSystemObjectEnum.Contacts.getCode(), PrdSystemLogEnum.UPDATE.getDesc() + PrdSystemLogEnum.FOLLOW.getDesc());
//        } else {
//            throw TwException.error("", "该数据已暂挂");
//        }
//
//    }


//    @Override
//    public List<CrmFollowVO> queryListFollow(Long objectId) {
//        return followService.queryFollowList(objectId, CrmFollowObjectEnum.Contacts.name());
//    }

    @Override
    public PagingVO<PrdSystemLogVO> queryLogList(PrdSystemLogQuery query) {
        query.setLogObject(PrdSystemObjectEnum.Contacts.getCode());
        return logService.pageLog(query);
    }

    @Override
    public void downloadBatch(HttpServletResponse response, PrdAbContactsQuery query) {
        ClassPathResource classPathResource = new ClassPathResource("template/prdAbContactsBatch.xlsx");
        PagingVO<PrdAbContactsVO> paging = paging(query);
        List<PrdAbContactsVO> records = paging.getRecords();
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create(inputStream);
            XSSFSheet batchProjectSheet = (XSSFSheet) workbook.getSheet("联系人数据");
            if (!CollectionUtils.isEmpty(records) && batchProjectSheet != null) {
                int nextRow = 1;
                for (PrdAbContactsVO dataPayload : records) {
                    Row row = batchProjectSheet.createRow(nextRow);
                    excelUtil.setCellValue(row, 0, nextRow); // 序号
                    excelUtil.setCellValue(row, 1, dataPayload.getBookName());//地址簿名称
                    excelUtil.setCellValue(row, 2, dataPayload.getContactsNo());// 联系人编号
                    excelUtil.setCellValue(row, 3, dataPayload.getContactsStatusName());// 联系人状态
                    excelUtil.setCellValue(row, 4, dataPayload.getContactsTypeName());// 联系人类型
                    excelUtil.setCellValue(row, 5, dataPayload.getContactsName());// 姓名
                    excelUtil.setCellValue(row, 6, dataPayload.getContactsPhone());// 手机
                    excelUtil.setCellValue(row, 7, dataPayload.getContactsTelephone());// /电话
                    excelUtil.setCellValue(row, 8, dataPayload.getContactsEmail());// 邮箱
                    excelUtil.setCellValue(row, 9, dataPayload.getContactsAddress());// 联系地址
                    excelUtil.setCellValue(row, 10, dataPayload.getSocialAccountType());// 社交账户类型
                    excelUtil.setCellValue(row, 11, dataPayload.getSocialAccount());// 社交账户
                    excelUtil.setCellValue(row, 12, dataPayload.getContactsDepartment());// 部门
                    excelUtil.setCellValue(row, 13, dataPayload.getContactsPosition());// 岗位
                    excelUtil.setCellValue(row, 14, dataPayload.getSexName());// 性别
                    excelUtil.setCellValue(row, 15, dataPayload.getBirthday());// 生日
                    Boolean isKeyPerson = dataPayload.getIsKeyPerson();
                    String isKeyPersonStr = isKeyPerson == null ? "否" : isKeyPerson ? "是" : "否";
                    excelUtil.setCellValue(row, 16, isKeyPersonStr);// 是否是决策人
                    nextRow++;
                }
            }
            String fileName = "联系人数据-" + LocalDate.now();
            ExcelUtil.writeResponse(response, fileName, workbook);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 全局翻译
     *
     * @param vo
     */
    void transferSystemSelection(PrdAbContactsVO vo) {
        vo.setContactsStatusName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.SystemStatus.getCode(), vo.getContactsStatus()));
        vo.setSexName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeSex.getCode(), vo.getSex()));
        vo.setContactsTypeName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.AbContacts_type.getCode(), vo.getContactsType()));

    }
}
