package com.elitesland.tw.tw5.server.prd.app.controller;

import com.elitesland.tw.tw5.api.prd.my.service.PrdUserService;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeePayload;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.common.TwOutputUtil;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

/**
 * APP-用户服务
 *
 * @author duwh
 * @date 2023-02-23
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/app")
@Slf4j
public class AppUserController {

    private final PrdUserService prdUserService;
    private final PrdOrgEmployeeService prdOrgEmployeeService;


    /**
     * APP-用户服务-查询个人数据
     * 移动端获取个人信息
     *
     * @return result
     */
    @GetMapping("/user/queryDetail")
    @ApiOperation("APP-用户服务-查询个人数据")
    public TwOutputUtil queryDetailForMobile() {
        return TwOutputUtil.ok(prdUserService.queryDetailForMobile());
    }

    /**
     * APP-用户服务-修改
     *
     * @param entity po类
     * @return result
     */
    @ApiOperation("APP-用户服务-修改")
    @PutMapping("/employee/update")
    public TwOutputUtil updateForApp(@RequestBody PrdOrgEmployeePayload entity) {
        prdOrgEmployeeService.updateForApp(entity);
        return TwOutputUtil.ok();
    }



}
