package com.elitesland.tw.tw5.server.prd.app.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * APP版本管理
 *
 * @author duwh
 * @date 2023-02-23
 */
@Entity
@Table(name = "app_version", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "app_version", comment = "APP版本管理")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class AppVersionDO extends BaseModel implements Serializable {
    /**
     * 版本名称
     */
    @Comment("版本名称")
    @Column()
    private String name;
    /**
     * 版本号
     */
    @Comment("版本号")
    @Column()
    private Integer version;
    /**
     * 更新日志
     */
    @Comment("更新日志")
    @Column()
    private String content;
    /**
     * 强制更新标记，0：不强制更新，1：强制更新
     */
    @Comment("强制更新标记，0：不强制更新，1：强制更新")
    @Column()
    private Integer forceFlag;
    /**
     * 文件地址code(安卓安卓包)
     */
    @Comment("文件地址code(安卓安卓包)")
    @Column()
    private String fileCode;
    /**
     * 下载地址（安卓安装包）
     */
    @Comment("下载地址（安卓安装包）")
    @Column()
    private String downloadUrl;
    /**
     * ALL 所有；Android 安卓； IOS 苹果手机
     */
    @Comment("ALL 所有；Android 安卓； IOS 苹果手机")
    @Column()
    private String type;

    @Comment(value = "是否展示 0 不展示  1展示", defaultValue = "0")
    @Column()
    private Integer showFlag = 0;
    /**
     * 拓展1
     */
    @Comment("拓展1")
    @Column()
    private String ext1;
    /**
     * 拓展2
     */
    @Comment("拓展2")
    @Column()
    private String ext2;
    /**
     * 拓展3
     */
    @Comment("拓展3")
    @Column()
    private String ext3;
    /**
     * 拓展4
     */
    @Comment("拓展4")
    @Column()
    private String ext4;
    /**
     * 拓展5
     */
    @Comment("拓展5")
    @Column()
    private String ext5;

    public void copy(AppVersionDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
