package com.elitesland.tw.tw5.server.prd.file.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serial;
import java.io.Serializable;

/**
 * 附件 文件
 *
 * @author duwh
 * @date 2022/09/20
 */
@Entity(name = "prd_file")
@Table(name = "prd_file")
@org.hibernate.annotations.Table(appliesTo = "prd_file", comment = "附件-文件")
@Getter
@Setter
@ToString
@Where(clause = "delete_flag = 0")
public class PrdFileDO extends BaseModel implements Serializable {

    @Serial
    private static final long serialVersionUID = 1982168960995188114L;

    /**
     * 文件夹主键
     */
    @Comment("文件夹主键")
    @Column()
    private Long folderId;

    /**
     * 文件名称
     */
    @Comment("文件名称")
    @Column()
    private String name;

    /**
     * 原文件名称
     */
    @Comment("原文件名称")
    @Column()
    private String fileName;

    /**
     * 真实文件名
     */
    @Comment("真实文件名")
    @Column()
    private String realName;

    /**
     * 文件路径
     */
    @Comment("文件路径")
    @Column()
    private String serverPath;

    /**
     * 格式后缀
     */
    @Comment("格式后缀")
    @Column()
    private String suffix;

    /**
     * 文件类型
     */
    @Comment("文件类型")
    @Column()
    private String fileType;

    /**
     * 文件类型desc
     */
    @Comment("文件类型")
    @Column()
    private String fileTypeDesc;

    /**
     * 文件大小
     */
    @Comment("文件大小(字节)")
    @Column()
    private Long fileSize;

    /**
     * 文件大小
     */
    @Comment("文件大小")
    @Column()
    private String fileSizeDesc;

    /**
     * 最新版本主键
     */
    @Comment("最新版本主键")
    @Column()
    private Long versionId;

    /**
     * 最新版本号
     */
    @Comment("最新版本号")
    @Column()
    private String versionNo;

    /**
     * 版本标记
     * 版本文件，0：非版本文件，1：版本文件
     */
    @Column(
        name = "version_flag",
        columnDefinition = "int(10) default '0' comment '版本文件，0：非版本文件，1：版本文件' "
    )
    private Integer versionFlag = 0;


    public PrdFileDO() {
    }

    public void copy(PrdFileDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
