package com.elitesland.tw.tw5.server.prd.org.controller;

import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgCompanyNoticePayload;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgCompanyNoticeQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgCompanyNoticeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgCompanyNoticeVO;
import com.elitesland.tw.tw5.api.common.TwOutputUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Api("公司公告管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/org")
@Slf4j
public class PrdOrgCompanyNoticeController {

    private final PrdOrgCompanyNoticeService service;

    /**
     * 新建
     *
     * @param entity po类
     * @return result
     */
    @ApiOperation("新增")
    @PostMapping("/company/notice/insert")
    public TwOutputUtil insert(PrdOrgCompanyNoticePayload entity) {
        PrdOrgCompanyNoticeVO vo = service.insert(entity);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 全部修改
     *
     * @param entity po类
     * @return result
     */
    @ApiOperation("修改")
    @PutMapping("/company/notice/update")
    public TwOutputUtil update(PrdOrgCompanyNoticePayload entity) {
        PrdOrgCompanyNoticeVO vo = service.update(entity);
        return TwOutputUtil.ok(vo);
    }


    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return result
     */
    @ApiOperation("逻辑删除")
    @DeleteMapping("/company/notice/delete")
    public TwOutputUtil delete(Long[] keys) {
        service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }


    /**
     * 根据id查询
     *
     * @param id 主键
     * @return result
     */
    @ApiOperation("根据id查询")
    @GetMapping("/company/notice/{id}")
    public TwOutputUtil queryByKey(@PathVariable Long id) {
        PrdOrgCompanyNoticeVO vo = service.queryByKey(id);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 分页条件查询
     *
     * @return result
     */
    @ApiOperation("分页条件查询")
    @GetMapping("/company/notice/pading")
    public TwOutputUtil queryPading(PrdOrgCompanyNoticeQuery query) {
        PagingVO<PrdOrgCompanyNoticeVO> paging = service.paging(query);
        return TwOutputUtil.ok(paging);
    }

    /**
     * 发布
     * @param keys 主键
     * @return
     */
    @ApiOperation("发布")
    @PutMapping("/company/notice/publish")
    public TwOutputUtil publish(Long[] keys) {
        service.publish(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 撤销
     * @param keys 主键
     * @return
     */
    @ApiOperation("撤销")
    @PutMapping("/company/notice/revoke")
    public TwOutputUtil revoke(Long[] keys) {
        service.revoke(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 列表查询
     * @param query 查询条件
     * @return
     */
    @ApiOperation("列表查询")
    @GetMapping("/company/notice/queryList")
    public TwOutputUtil queryList(PrdOrgCompanyNoticeQuery query) {
        // 首页查询
        List<OrderItem> orderse = new ArrayList<>();
        orderse.add(OrderItem.desc("topFlag"));
        orderse.add(OrderItem.asc("sort"));
        orderse.add(OrderItem.desc("createTime"));
        query.setOrders(orderse);
        List<PrdOrgCompanyNoticeVO> voList = service.queryList(query);
        return TwOutputUtil.ok(voList);
    }

}
