package com.elitesland.tw.tw5.server.prd.org.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 员工复合能力表
 *
 * @author 王顶
 * @date 2022/11/03
 */
@Entity
@Table(name = "prd_org_employee_composite",
        indexes = {
                @Index(name = "user_index", columnList = "user_id")})
@org.hibernate.annotations.Table(appliesTo = "prd_org_employee_composite", comment = "员工复合能力表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdOrgEmployeeCompositeDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 1L;

    @Comment("系统用户ID")
    @Column(name = "user_id")
    private Long userId;

    /**
     * 工种
     */
    @Comment("工种")
    @Column()
    private String workType;
    /**
     * 专业级别
     */
    @Comment("专业级别")
    @Column()
    private String specialtyLevel;
    /**
     * 管理级别
     */
    @Comment("管理级别")
    @Column()
    private String manageLevel;

}
