package com.elitesland.tw.tw5.server.prd.org.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 员工表
 *
 * @author 王顶
 * @date 2022/11/03
 */
@Entity
@Table(name = "prd_org_employee",
        indexes = {@Index(name = "person_index", columnList = "person_id"),
                @Index(name = "wecom_index", columnList = "wecom_id"),
                @Index(name = "userv4_index", columnList = "user_id_v4"),
                @Index(name = "user_index", columnList = "user_id")})
@org.hibernate.annotations.Table(appliesTo = "prd_org_employee", comment = "员工表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdOrgEmployeeDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 1L;


    @Comment("自然人ID")
    @Column(name = "person_id")
    private Long personId;

    @Comment("系统用户ID")
    @Column(name = "user_id")
    private Long userId;

    @Comment("tw4.0系统用户ID")
    @Column(name = "user_id_v4")
    private Long userIdV4;

    @Comment("企业微信ID")
    @Column(name = "wecom_id")
    private String wecomId;

    @Comment("公司ID")
    private Long companyId;


    @Comment("员工编号")
    @Column()
    private String employeeNo;

    @Comment("员工名称")
    @Column()
    private String employeeName;

    @Comment("资源状态")
    @Column()
    private String resourceStatus;

    @Comment("人事状态")
    @Column()
    private String hrStatus;//0：有效，1：无效

    @Comment("入职日期")
    @Column()
    private LocalDate enrollDate;

    @Comment("安全级别")
    @Column()
    private Integer accessLevel;

    @Comment("岗位")
    @Column()
    private String jobs;

    @Comment("我的快捷入口")
    @Column()
    private String shortcutIds = "";

    @Comment("ticket")
    @Column()
    private String pcLoginTicket;

    /**
     * 当量系数
     */
    @Comment("当量系数")
    @Column()
    private BigDecimal eqvaRatio;

    @Comment("排序")
    @Column()
    private Integer sortIndex;

    private String extString1;
    private String extString2;
    private String extString3;
    private String extString4;
    private String extString5;
    private String extString6;
    private String extString7;
    private String extString8;
    private String extString9;
    private String extString10;
    private String extString11;
    private String extString12;

    private LocalDate extDate1;
    private LocalDate extDate2;
    private LocalDate extDate3;
    private LocalDate extDate4;
    private LocalDate extDate5;
    private LocalDate extDate6;
    private LocalDate extDate7;
    private LocalDate extDate8;
}
