package com.elitesland.tw.tw5.server.prd.org.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;

@Entity
@Table(name = "prd_org_employee_ref",
        indexes = {@Index(name = "user_index", columnList = "user_id"),
                @Index(name = "org_index", columnList = "org_id"),
                @Index(name = "refv4_index", columnList = "ref_id_v4")})
@org.hibernate.annotations.Table(appliesTo = "prd_org_employee_ref", comment = "组织员工关系表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdOrgEmployeeRefDO extends BaseModel implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;


    @Comment("员工ID")
    @Column(name = "user_id")
    private Long userId;

    @Comment("tw4.0系统关系ID")
    @Column(name = "ref_id_v4")
    private Long refIdV4;

    @Comment("组织id")
    @Column(name = "org_id")
    private Long orgId;

    @Comment("上级员工ID")
    @Column()
    private Long parentId = 0L;

    @Comment("排序号")
    @Column()
    private Integer sortIndex = 1;

    @Comment("是否是默认组织")
    @Column()
    private Integer isDefault = 1;

    @Comment("加入日期")
    @Column()
    private LocalDate joinDate;

    @Comment("离开日期")
    @Column()
    private LocalDate leaveDate;

    @Comment("是否是拷贝数据")
    @Column()
    private Integer isCopy = 0;

    @Override
    public Object clone() {
        PrdOrgEmployeeRefDO stu = null;
        try {
            stu = (PrdOrgEmployeeRefDO) super.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return stu;
    }
}
