package com.elitesland.tw.tw5.server.prd.org.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;

@Entity
@Table(name = "prd_org_person")
@org.hibernate.annotations.Table(appliesTo = "prd_org_person", comment = "自然人表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdOrgPersonDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 1L;

    @Comment("用户账号")
    @Column()
    private String userName;

//    @Comment("用户名称")
//    @Column()
//    private String firstName;

    @Comment("手机号")
    @Column()
    private String mobile;

    @Comment("是否启用")
    @Column()
    private Boolean enabled;

    @Comment(value = "用户邮箱地址")
    @Column()
    private String email;

    @Comment("姓名")
    @Column()
    private String personName;

    @Comment("外文名")
    @Column()
    private String foreignName;

    @Comment("证件类型")
    @Column()
    private String idType;


    @Comment("证件号码")
    @Column()
    private String idNo;

    @Comment("证件开始日")
    @Column()
    private LocalDate idValidFrom;

    @Comment("证件到期日")
    @Column()
    private LocalDate idValidTo;

    @Comment("证件url")
    @Column()
    private String idValidCodes;

    @Comment("头像url")
    @Column()
    private String headCodes;

    @Comment("生日")
    @Column()
    private LocalDate birthday;

    @Comment("性别")
    @Column()
    private String sex;

    @Comment("国籍")
    @Column()
    private String nationality;

    @Comment("籍贯")
    @Column()
    private String birthplace;

    @Comment("民族")
    @Column()
    private String nation;

    @Comment("婚姻状况")
    @Column()
    private Integer marital;

    @Comment("通讯地址")
    @Column()
    private String addr;

    @Comment("紧急联系人")
    @Column()
    private String urgency_name;

    @Comment("手机号")
    @Column()
    private String urgency_mobile;

    @Comment("关系")
    @Column()
    private String urgency_ref;

    @Comment("排序")
    @Column()
    private Integer sortIndex;

//    private String extString1;
//    private String extString2;
//    private String extString3;
//    private String extString4;
//    private String extString5;
//    private String extString6;
//    private String extString7;
//    private String extString8;
//    private String extString9;
//    private String extString10;

}
