package com.elitesland.tw.tw5.server.prd.org.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name = "prd_org_role", indexes = {@Index(name = "org_index", columnList = "org_id")})
@org.hibernate.annotations.Table(appliesTo = "prd_org_role", comment = "组织角色表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdOrgRoleDO extends BaseModel implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    @Comment("组织ID")
    @Column(name = "org_id")
    private Long orgId;

    @Comment("角色备份前ID")
    @Column()
    private Long changeId = 0L;

    @Comment("角色名称")
    @Column()
    private String roleName;

    @Comment("角色编号")
    @Column()
    private String roleCode;

    @Comment("角色负责人")
    @Column()
    private String roleEmployees;


    @Comment("是否是拷贝数据")
    @Column()
    private Integer isCopy = 0;


    private String extString1;
    private String extString2;
    private String extString3;
    private String extString4;
    private String extString5;
    private String extString6;
    private String extString7;
    private String extString8;
    private String extString9;
    private String extString10;

    @Override
    public Object clone() {
        PrdOrgRoleDO stu = null;
        try {
            stu = (PrdOrgRoleDO) super.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return stu;
    }
}
