package com.elitesland.tw.tw5.server.prd.org.repo;

import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

@Repository
public interface PrdOrgEmployeeRepo extends JpaRepository<PrdOrgEmployeeDO, Long>, QuerydslPredicateExecutor<PrdOrgEmployeeDO> {

    @Query(value = "select userId from PrdOrgEmployeeDO where employeeNo in ?1")
    List<Long> queryUserIdByEmployeeNo(List<Long> collect);


    @Query(value = "select userId from PrdOrgEmployeeDO where userIdV4 = ?1 and deleteFlag=0")
    Long queryUserIdV4(Long userIdV4);

    @Query(value = "select userIdV4 from PrdOrgEmployeeDO where userId = ?1 and deleteFlag=0")
    Long getUserIdV4ByUserId(Long userId);

    @Query(value = "select userIdV4 from PrdOrgEmployeeDO where userId = ?1 and deleteFlag=0")
    Long queryV4UserId(Long userId);

    @Query(value = "select userId from PrdOrgEmployeeDO where employeeName like '%?1%'")
    List<Long> queryUserIdsByNameLike(Long saleUserName);

    @Query("select userId as userId,userIdV4 as userIdV4 from PrdOrgEmployeeDO where deleteFlag=0")
    List<Map<String, Object>> getV4AndV5UserIds();
}
