package com.elitesland.tw.tw5.server.prd.org.service;

import com.elitesland.tw.tw5.api.common.TwException;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgDimensionPayload;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgDimensionQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgDimensionService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDimensionVO;
import com.elitesland.tw.tw5.server.prd.org.convert.PrdOrgDimensionConvert;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgDimensionDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationRefDO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgDimensionDAO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 维度管理service
 *
 * @author wangding
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdOrgDimensionServiceImpl implements PrdOrgDimensionService {
    private final PrdOrgDimensionDAO dao;
    private final PrdOrgOrganizationService service;

    @Transactional
    @Override
    public PrdOrgDimensionVO insert(PrdOrgDimensionPayload payload) {
        if (payload.getDefaultFlag() == 0) {
            updateDefaultFlag();
        }
        payload.setVersionId(0L);
        PrdOrgDimensionDO ado = PrdOrgDimensionConvert.INSTANCE.toDo(payload);
        dao.save(ado);
        return PrdOrgDimensionConvert.INSTANCE.toVo(ado);
    }

    @Transactional
    @Override
    public PrdOrgDimensionVO insertByTenant(PrdOrgDimensionPayload payload) {
        if (payload.getDefaultFlag() == 0) {
            updateDefaultFlag();
        }
        payload.setVersionId(0L);
        PrdOrgDimensionDO ado = PrdOrgDimensionConvert.INSTANCE.toDo(payload);

        // 租户初始化数据
        if (null != payload.getInitTenantId()) {
            ado.setTenantId(payload.getInitTenantId());
        }
        dao.save(ado);
        return PrdOrgDimensionConvert.INSTANCE.toVo(ado);
    }

    @Transactional
    @Override
    public Long update(PrdOrgDimensionPayload payload) {

        if (payload.getDefaultFlag() == 0) {
            updateDefaultFlag();
        }
        return dao.updateByKeyDynamic(payload);
    }

    private void updateDefaultFlag() {
        dao.updateDefaultFlag();
    }

    @Transactional
    @Override
    public Long updateStatus(Long id, Integer status) {
        if (id != null && status != null) {
            if (status == 1) {
                PrdOrgDimensionDO pdo = dao.queryByKey(id);
                if (pdo.getDefaultFlag() == 0) {
                    throw TwException.error("", "默认维度不可关闭");
                }
            }
            dao.updateStatus(id, status);
        } else {
            throw TwException.error("", "参数异常");
        }
        return 0L;
    }

    @Transactional
    @Override
    public boolean deleteSoft(List<Long> keys) {
        for (int i = 0; i < keys.size(); i++) {
            Long dimensionId = keys.get(i);
            List<PrdOrgOrganizationRefDO> list = dao.queryOrgList(dimensionId);
            PrdOrgDimensionDO pdo = dao.queryByKey(dimensionId);
            if (pdo.getDefaultFlag() == 0) {
                throw TwException.error("", "默认维度及存在下属组织不可删除");
            }
            for (PrdOrgOrganizationRefDO refDo : list) {
                if (!service.deleteSoft(dimensionId, refDo.getOrgId())) {
                    throw TwException.error("", "默认维度及存在下属组织不可删除");
                }
            }
            dao.deleteSoft(dimensionId);
        }
        return true;
    }

    @Override
    public List<PrdOrgDimensionVO> queryList() {
        PrdOrgDimensionQuery query = new PrdOrgDimensionQuery();
        query.setVersionId(0L);

        return dao.queryList(query);
    }

    @Override
    public PrdOrgDimensionVO queryByVersionId(Long versionId) {
        return dao.queryByVersionId(versionId);
    }
}
