package com.elitesland.tw.tw5.server.prd.sale.controller;

import com.elitesland.tw.tw5.api.prd.sale.payload.SaleContractPayload;
import com.elitesland.tw.tw5.api.prd.sale.query.SaleContractQuery;
import com.elitesland.tw.tw5.api.prd.sale.service.SaleContractService;
import com.elitesland.tw.tw5.api.prd.sale.vo.SaleContractVO;
import com.elitesland.tw.tw5.api.common.TwOutputUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;
import java.util.Arrays;
import java.util.List;


/**
 * 合同控制器
 *
 * @author duwh
 * @date 2022/09/27
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/sale")
@Slf4j
public class SaleContractController {

    private final SaleContractService service;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/contract")
    public TwOutputUtil insert(SaleContractPayload payload) {
        return TwOutputUtil.ok(service.insert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("/contract")
    public TwOutputUtil update(SaleContractPayload payload) {
        return TwOutputUtil.ok(service.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/contract/{key}")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        SaleContractVO vo = service.queryByKey(key);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/contract/paging")
    public TwOutputUtil paging(SaleContractQuery query) {
        PagingVO<SaleContractVO> paging = service.paging(query);
        return TwOutputUtil.ok(paging);
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/contract/list")
    public TwOutputUtil queryList(SaleContractQuery query) {
        List<SaleContractVO> vos = service.queryList(query);
        return TwOutputUtil.ok(vos);
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/contract/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys) {
        service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }


}
