package com.elitesland.tw.tw5.server.prd.sale.controller;

import com.elitesland.tw.tw5.api.common.TwException;
import com.elitesland.tw.tw5.api.prd.file.service.PrdFileRefService;
import com.elitesland.tw.tw5.api.prd.file.service.PrdFileService;
import com.elitesland.tw.tw5.api.prd.file.vo.PrdFileVO;
import com.elitesland.tw.tw5.api.prd.sale.payload.SaleContractTempPayload;
import com.elitesland.tw.tw5.api.prd.sale.query.SaleContractTempQuery;
import com.elitesland.tw.tw5.api.prd.sale.service.SaleContractTempService;
import com.elitesland.tw.tw5.api.prd.sale.vo.SaleContractTempVO;
import com.elitesland.tw.tw5.api.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdFileBusinessTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdFileDocTypeEnum;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;


/**
 * 合同模板控制器
 *
 * @author duwh
 * @date 2022/09/27
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/sale")
@Slf4j
public class SaleContractTempController {

    private final SaleContractTempService service;
    private final PrdFileService prdFileService;
    private final PrdFileRefService prdFileRefService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/contractTemp")
    public TwOutputUtil insert(SaleContractTempPayload payload) throws IOException {
        if (StringUtils.isEmpty(payload.getName())) {
            throw TwException.error("", "name is empty");
        }
        final SaleContractTempVO insert = service.insert(payload);
        // 新增完合同模板后，返回一个附件主键
        final PrdFileVO fileVo = prdFileService.createByContractTemp(payload.getName(), null);
        List<PrdFileVO> listFile = new ArrayList<>();
        if (fileVo != null) {
            listFile.add(fileVo);
            // 附件、业务表关系绑定
            prdFileRefService.insert(fileVo.getId(), insert.getId(), PrdFileBusinessTypeEnum.CONTRACT.getCode(), PrdFileDocTypeEnum.CONTRACT_TEMP.getCode());
        }
        insert.setListFile(listFile);

        return TwOutputUtil.ok(insert);
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("/contractTemp")
    public TwOutputUtil update(SaleContractTempPayload payload) {
        return TwOutputUtil.ok(service.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/contractTemp/{key}")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        SaleContractTempVO vo = service.queryByKey(key);
        // 附件、业务表关系绑定
        final List<PrdFileVO> listFile = prdFileRefService.listFile(key, PrdFileBusinessTypeEnum.CONTRACT.getCode(), PrdFileDocTypeEnum.CONTRACT_TEMP.getCode());
        vo.setListFile(listFile);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/contractTemp/paging")
    public TwOutputUtil paging(SaleContractTempQuery query) {
        PagingVO<SaleContractTempVO> paging = service.paging(query);
        paging.getRecords().forEach(saleContractTempVO -> {
            // 附件、业务表关系
            final List<PrdFileVO> listFile = prdFileRefService.listFile(saleContractTempVO.getId(), PrdFileBusinessTypeEnum.CONTRACT.getCode(), PrdFileDocTypeEnum.CONTRACT_TEMP.getCode());
            saleContractTempVO.setListFile(listFile);
        });
        return TwOutputUtil.ok(paging);
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/contractTemp/list")
    public TwOutputUtil queryList(SaleContractTempQuery query) {
        List<SaleContractTempVO> vos = service.queryList(query);
        vos.forEach(saleContractTempVO -> {
            // 附件、业务表关系
            final List<PrdFileVO> listFile = prdFileRefService.listFile(saleContractTempVO.getId(), PrdFileBusinessTypeEnum.CONTRACT.getCode(), PrdFileDocTypeEnum.CONTRACT_TEMP.getCode());
            saleContractTempVO.setListFile(listFile);
        });
        return TwOutputUtil.ok(vos);
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/contractTemp/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys) {
        service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }


}
