package com.elitesland.tw.tw5.server.prd.sale.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;


/**
 * 合同
 *
 * @author duwh
 * @date 2022/09/27
 */
@Entity(name = "sale_contract")
@Table(name = "sale_contract")
@org.hibernate.annotations.Table(appliesTo = "sale_contract", comment = "合同")
@Getter
@Setter
@ToString
@Where(clause = "delete_flag = 0")
public class SaleContractDO extends BaseModel implements Serializable {

    /**
     * 模板主键
     */
    @Comment("合同类别主键 sale_contract_temp.id")
    @Column()
    private Long tempId;

    /**
     * 标签id
     */
    @Comment("标签主键 待定.id")
    @Column()
    private Long tagId;

    /**
     * 合同名称
     */
    @Comment("合同名称")
    @Column()
    private String contractName;

    /**
     * 合同编号
     */
    @Comment("合同编号")
    @Column()
    private String contractNo;

    /**
     * 合同金额
     */
    @Comment("合同金额")
    @Column()
    private BigDecimal amt;

    /**
     * 合同状态
     */
    @Comment("合同状态")
    @Column()
    private String contractStatus;

    /**
     * 合同描述
     */
    @Comment("合同描述")
    @Column()
    private String contractDesc;

    /**
     * 流程实例ID
     */
    @Comment("流程实例ID")
    @Column()
    private String procInstId;

    /**
     * 流程审批状态
     */
    @Comment("流程审批状态")
    @Column()
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;

    /**
     * 提交时间
     */
    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;

    /**
     * 审批时间
     */
    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;


    public SaleContractDO() {
    }

    public void copy(SaleContractDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
