package com.elitesland.tw.tw5.server.prd.schedule.controller;

import com.elitesland.tw.tw5.api.prd.schedule.payload.PrdCalendarPayload;
import com.elitesland.tw.tw5.api.prd.schedule.query.PrdCalendarQuery;
import com.elitesland.tw.tw5.api.prd.schedule.sercvice.PrdCalendarService;
import com.elitesland.tw.tw5.api.prd.schedule.vo.PrdCalendarVO;
import com.elitesland.tw.tw5.api.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 日历管理
 * @author zoey
 * @date 2022/4/19 - 14:29
 */
@Api("日历管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/scd")
@Slf4j
public class PrdCalendarController {

    private final PrdCalendarService service;

    /**
     * 新建或修改
     * @param payload po类
     * @return result
     */
    @ApiOperation("简单新增和修改")
    @PostMapping("/calendar/saveOne")
    public TwOutputUtil insert(@RequestBody PrdCalendarPayload payload) {
        PrdCalendarVO vo = service.insertOrUpdate(payload);
        return TwOutputUtil.ok(vo);
    }



    /**
     * 列表查询不分页(默认列表)
     * @param query 查询参数
     * @return result
     */
    @ApiOperation("列表查询")
    @GetMapping("/calendar/list")
    public TwOutputUtil queryList(PrdCalendarQuery query) {
        List<PrdCalendarVO> list = service.queryList(query);
        return TwOutputUtil.ok(list);
    }

    /**
     * 详情查询
     * @param id 主键
     * @return result
     */
    @ApiOperation("详情查询")
    @GetMapping("/calendar/detail/{id}")
    public TwOutputUtil queryDetail(@PathVariable Long id) {
        PrdCalendarVO vo= service.queryDetail(id);
        return TwOutputUtil.ok(vo);
    }



    /**
     * 逻辑删除
     * @param keys 主键
     * @return result
     */
    @ApiOperation("逻辑删除")
    @DeleteMapping("/calendar/delete")
    public TwOutputUtil delete(Long[] keys) {
        service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }
}
