package com.elitesland.tw.tw5.server.prd.shorturl.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.shorturl.payload.ShortUrlConfPayload;
import com.elitesland.tw.tw5.api.prd.shorturl.query.ShortUrlConfQuery;
import com.elitesland.tw.tw5.api.prd.shorturl.service.ShortUrlConfService;
import com.elitesland.tw.tw5.api.prd.shorturl.vo.ShortUrlConfVO;
import com.elitesland.tw.tw5.api.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 短链服务配置
 *
 * @author duwh
 * @date 2023-05-19
 */
@Api(tags = "短链服务配置")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/prd/shortUrlConf")
@Slf4j
public class ShortUrlConfController {

    private final ShortUrlConfService shortUrlConfService;

    /**
     * 短链服务配置-新增
     *

     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("短链服务配置-新增")
    public TwOutputUtil<ShortUrlConfVO> insert(@RequestBody ShortUrlConfPayload payload){
        return TwOutputUtil.ok(shortUrlConfService.insert(payload));
    }

    /**
     * 短链服务配置-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("短链服务配置-更新")
    public TwOutputUtil<ShortUrlConfVO> update(@RequestBody ShortUrlConfPayload payload){
        return TwOutputUtil.ok(shortUrlConfService.update(payload));
    }

    /**
     * 短链服务配置-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("短链服务配置-主键查询")
    public TwOutputUtil<ShortUrlConfVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(shortUrlConfService.queryByKey(key));
    }

    /**
     * 短链服务配置-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("短链服务配置-分页")
    public TwOutputUtil<PagingVO<ShortUrlConfVO>> paging(ShortUrlConfQuery query) {
        return TwOutputUtil.ok(shortUrlConfService.queryPaging(query));
    }

    /**
     * 短链服务配置-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("短链服务配置-查询列表")
    public TwOutputUtil<List<ShortUrlConfVO>> queryList(ShortUrlConfQuery query) {
        return TwOutputUtil.ok(shortUrlConfService.queryListDynamic(query));
    }

    /**
     * 短链服务配置-统计
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/count")
    // @UdcNameClass
    @ApiOperation("短链服务配置-统计")
    public TwOutputUtil<Long> count(ShortUrlConfQuery query) {
        return TwOutputUtil.ok(shortUrlConfService.count(query));
    }

    /**
     * 短链服务配置-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("短链服务配置-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        shortUrlConfService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
