package com.elitesland.tw.tw5.server.prd.shorturl.controller;

import com.elitesland.tw.tw5.api.prd.shorturl.service.ShortUrlRefService;
import com.elitesland.tw.tw5.api.prd.shorturl.service.ShortUrlRequestLogService;
import com.elitesland.tw.tw5.api.prd.shorturl.vo.ShortUrlRefVO;
import com.elitesland.tw.tw5.api.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 短链
 *
 * @author duwh
 * @date 2023-05-29
 */
@Api(tags = "短链")
@Controller
@RequiredArgsConstructor
@RequestMapping("/s")
@Slf4j
public class ShortUrlRedirectController {

    private final ShortUrlRefService shortUrlRefService;
    private final ShortUrlRequestLogService shortUrlRequestLogService;

    /**
     * 短链-短链重定向
     *
     * @param code 短链地址识别码
     * @return {@link TwOutputUtil}
     */
    @GetMapping("r/{code}")
    @ApiOperation("短链-短链重定向")
    public void redirect(@PathVariable String code, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ShortUrlRefVO shortUrlRefVO = shortUrlRefService.queryByCodeAndAddVisitNum(code);
        if (null == shortUrlRefVO) {
            shortUrlRequestLogService.log(shortUrlRefVO, request);
            return;
        }
        shortUrlRequestLogService.log(shortUrlRefVO, request);
        String longUrl = shortUrlRefVO.getLongUrl();
        if (StringUtils.hasText(longUrl)) {
            log.info("URL:{} ,重定向redirect URL:{}", shortUrlRefVO.getShortUrl(), longUrl);
            response.setHeader("Location", longUrl);
            response.setStatus(HttpServletResponse.SC_MOVED_TEMPORARILY);
            response.sendRedirect(longUrl);
        }
    }

    /**
     * 短链-短链转发
     *
     * @param code 短链地址识别码
     * @return {@link TwOutputUtil}
     */
    @GetMapping("f/{code}")
    @ApiOperation("短链-短链转发")
    public String forward(@PathVariable String code, HttpServletResponse response) {
        ShortUrlRefVO shortUrlRefVO = shortUrlRefService.queryByCodeAndAddVisitNum(code);
        if (null == shortUrlRefVO) {
            return null;
        }
        String longUrl = shortUrlRefVO.getLongUrl();
        if (StringUtils.hasText(longUrl)) {
            log.info("URL:{} ,转发redirect URL:{}", shortUrlRefVO.getShortUrl(), longUrl);
            return "forword:" + longUrl;
        }
        return null;
    }


}
