package com.elitesland.tw.tw5.server.prd.shorturl.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.shorturl.payload.ShortUrlRefPayload;
import com.elitesland.tw.tw5.api.prd.shorturl.query.ShortUrlRefQuery;
import com.elitesland.tw.tw5.api.prd.shorturl.service.ShortUrlRefService;
import com.elitesland.tw.tw5.api.prd.shorturl.vo.ShortUrlRefVO;
import com.elitesland.tw.tw5.api.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 短链服务关系表
 *
 * @author duwh
 * @date 2023-05-19
 */
@Api(tags = "短链服务关系表")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/prd/shortUrlRef")
@Slf4j
public class ShortUrlRefController {

    private final ShortUrlRefService shortUrlRefService;

    @PostMapping("saveRedirect")
    @ApiOperation("测试生成短链")
    public TwOutputUtil<ShortUrlRefVO> saveRedirect(String longUrlSuffix){
        return TwOutputUtil.ok(shortUrlRefService.saveRedirect(longUrlSuffix));
    }

    @PostMapping("saveForward")
    @ApiOperation("测试生成短链")
    public TwOutputUtil<ShortUrlRefVO> saveForward(String longUrlSuffix){
        return TwOutputUtil.ok(shortUrlRefService.saveForward(longUrlSuffix));
    }

    /**
     * 短链服务关系表-新增
     *

     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("短链服务关系表-新增")
    public TwOutputUtil<ShortUrlRefVO> insert(@RequestBody ShortUrlRefPayload payload){
        return TwOutputUtil.ok(shortUrlRefService.insert(payload));
    }

    /**
     * 短链服务关系表-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("短链服务关系表-更新")
    public TwOutputUtil<ShortUrlRefVO> update(@RequestBody ShortUrlRefPayload payload){
        return TwOutputUtil.ok(shortUrlRefService.update(payload));
    }

    /**
     * 短链服务关系表-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("短链服务关系表-主键查询")
    public TwOutputUtil<ShortUrlRefVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(shortUrlRefService.queryByKey(key));
    }

    /**
     * 短链服务关系表-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("短链服务关系表-分页")
    public TwOutputUtil<PagingVO<ShortUrlRefVO>> paging(ShortUrlRefQuery query) {
        return TwOutputUtil.ok(shortUrlRefService.queryPaging(query));
    }

    /**
     * 短链服务关系表-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
//    @GetMapping("/list")
//    // @UdcNameClass
//    @ApiOperation("短链服务关系表-查询列表")
//    public TwOutputUtil queryList(ShortUrlRefQuery query) {
//        return TwOutputUtil.ok(shortUrlRefService.queryListDynamic(query));
//    }

    /**
     * 短链服务关系表-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("短链服务关系表-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        shortUrlRefService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
