package com.elitesland.tw.tw5.server.prd.shorturl.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.shorturl.query.ShortUrlRequestLogQuery;
import com.elitesland.tw.tw5.api.prd.shorturl.service.ShortUrlRequestLogService;
import com.elitesland.tw.tw5.api.prd.shorturl.vo.ShortUrlRequestLogVO;
import com.elitesland.tw.tw5.api.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 短链服务请求记录
 *
 * @author duwh
 * @date 2023-05-19
 */
@Api(tags = "短链服务请求记录")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/prd/shortUrlRequestLog")
@Slf4j
public class ShortUrlRequestLogController {

    private final ShortUrlRequestLogService shortUrlRequestLogService;

//    /**
//     * 短链服务请求记录-新增
//     *
//
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PostMapping
//    @ApiOperation("短链服务请求记录-新增")
//    public TwOutputUtil insert(@RequestBody ShortUrlRequestLogPayload payload){
//        return TwOutputUtil.ok(shortUrlRequestLogService.insert(payload));
//    }
//
//    /**
//     * 短链服务请求记录-更新
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PutMapping
//    @ApiOperation("短链服务请求记录-更新")
//    public TwOutputUtil update(@RequestBody ShortUrlRequestLogPayload payload){
//        return TwOutputUtil.ok(shortUrlRequestLogService.update(payload));
//    }

    /**
     * 短链服务请求记录-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("短链服务请求记录-主键查询")
    public TwOutputUtil<ShortUrlRequestLogVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(shortUrlRequestLogService.queryByKey(key));
    }

    /**
     * 短链服务请求记录-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("短链服务请求记录-分页")
    public TwOutputUtil<PagingVO<ShortUrlRequestLogVO>> paging(ShortUrlRequestLogQuery query) {
        return TwOutputUtil.ok(shortUrlRequestLogService.queryPaging(query));
    }

    /**
     * 短链服务请求记录-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
//    @GetMapping("/list")
//    // @UdcNameClass
//    @ApiOperation("短链服务请求记录-查询列表")
//    public TwOutputUtil queryList(ShortUrlRequestLogQuery query) {
//        return TwOutputUtil.ok(shortUrlRequestLogService.queryListDynamic(query));
//    }

    /**
     * 短链服务请求记录-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("短链服务请求记录-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        shortUrlRequestLogService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
