package com.elitesland.tw.tw5.server.prd.system.controller;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemHelpPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemHelpQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemHelpService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemHelpVO;
import com.elitesland.tw.tw5.api.common.TwOutputUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;

import static com.elitesland.tw.tw5.server.prd.common.SystemConstants.API_SYSTEM;

/**
 * 系统功能处理-帮助管理
 * @author Lemon
 */
@Api("系统功能处理-帮助管理")
@RestController
@RequiredArgsConstructor
@RequestMapping(API_SYSTEM)
@Slf4j
public class PrdSystemHelpController {
    private final PrdSystemHelpService service;

    /**
     * 新建
     *
     * @param payload po类
     * @return result
     */
    @ApiOperation("新增")
    @PostMapping("/help/insert")
    public TwOutputUtil insert(PrdSystemHelpPayload payload) {
        PrdSystemHelpVO vo = service.insert(payload);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 全部修改
     *
     * @param payload po类
     * @return result
     */
    @ApiOperation("修改")
    @PutMapping("/help/update")
    public TwOutputUtil update(PrdSystemHelpPayload payload) {
        PrdSystemHelpVO vo = service.update(payload);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return result
     */
    @ApiOperation("逻辑删除")
    @DeleteMapping("/help/delete")
    public TwOutputUtil delete(Long[] keys) {
        service.deleteSoft(keys);
        return TwOutputUtil.ok();
    }

    @ApiOperation("主键查询")
    @GetMapping("/help/{key}")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        PrdSystemHelpVO vo = service.queryByKey(key);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation("分页查询")
    @GetMapping("/help/paging")
    public TwOutputUtil paging(PrdSystemHelpQuery query) {
        PagingVO<PrdSystemHelpVO> paging = service.paging(query);
        return TwOutputUtil.ok(paging);
    }

    @ApiOperation("列表查询")
    @GetMapping("/help/queryList")
    public TwOutputUtil queryList(PrdSystemHelpQuery query) {
        List<PrdSystemHelpVO> list = service.queryList(query);
        return TwOutputUtil.ok(list);
    }

}
