package com.elitesland.tw.tw5.server.prd.system.controller;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemProblemFeedbackPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemProblemFeedbackQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemProblemFeedbackService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemProblemFeedbackVO;
import com.elitesland.tw.tw5.api.common.TwOutputUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import static com.elitesland.tw.tw5.server.prd.common.SystemConstants.API_SYSTEM;

/**
 * 系统功能处理-问题反馈
 *
 * @author Lemon
 */
@Api("系统功能处理-问题反馈")
@RestController
@RequiredArgsConstructor
@RequestMapping(API_SYSTEM)
@Slf4j
public class PrdSystemProblemFeedbackController {
    private final PrdSystemProblemFeedbackService service;

    /**
     * 新建
     *
     * @param payload po类
     * @return result
     */
    @ApiOperation("新增")
    @PostMapping("/problemFeedback/insert")
    public TwOutputUtil insert(PrdSystemProblemFeedbackPayload payload) {
        PrdSystemProblemFeedbackVO vo = service.insert(payload);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 全部修改
     *
     * @param payload po类
     * @return result
     */
    @ApiOperation("修改")
    @PutMapping("/problemFeedback/update")
    public TwOutputUtil update(PrdSystemProblemFeedbackPayload payload) {
        PrdSystemProblemFeedbackVO vo = service.update(payload);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation("分页查询")
    @GetMapping("/problemFeedback/paging")
    public TwOutputUtil paging(PrdSystemProblemFeedbackQuery query) {
        PagingVO<PrdSystemProblemFeedbackVO> paging = service.paging(query);
        return TwOutputUtil.ok(paging);
    }

    @ApiOperation("主键查询")
    @GetMapping("/problemFeedback/{key}")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        PrdSystemProblemFeedbackVO vo = service.queryByKey(key);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 根据主键动态修改
     *
     * @param payload po类
     * @return result
     */
    @ApiOperation("根据主键动态修改")
    @PutMapping("/problemFeedback/updateByKeyDynamic")
    public TwOutputUtil updateByKeyDynamic(PrdSystemProblemFeedbackPayload payload) {
        service.updateByKeyDynamic(payload);
        return TwOutputUtil.ok();

    }

    /**
     * 关闭问题
     *
     * @param payload
     * @return result
     */
    @ApiOperation("关闭问题")
    @PutMapping("/problemFeedback/close")
    public TwOutputUtil closeProblemFeedback(PrdSystemProblemFeedbackPayload payload) {
        service.closeProblemFeedback(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 打开问题
     *
     * @param payload
     * @return result
     */
    @ApiOperation("打开问题")
    @PutMapping("/problemFeedback/open")
    public TwOutputUtil openProblemFeedback(PrdSystemProblemFeedbackPayload payload) {
        service.openProblemFeedback(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 申请加急问题
     *
     * @param payload
     * @return result
     */
    @ApiOperation("申请加急")
    @PutMapping("/problemFeedback/urgent")
    public TwOutputUtil urgentProblemFeedback(PrdSystemProblemFeedbackPayload payload) {
        service.urgentProblemFeedback(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 修改常见问题标志
     *
     * @param payload
     * @return result
     */
    @ApiOperation("修改常见问题标志")
    @PutMapping("/problemFeedback/common")
    public TwOutputUtil commonProblemFeedback(PrdSystemProblemFeedbackPayload payload) {
        service.commonProblemFeedback(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 查询时间段内的问题数量和解决数量
     *
     * @param query
     * @return result
     */
    @ApiOperation("查询时间段内的问题数量和解决数量")
    @GetMapping("/problemFeedback/statisticalNumber")
    public TwOutputUtil statisticalNumber(PrdSystemProblemFeedbackQuery query) {
        LocalDateTime startCreateTime = query.getStartCreateTime();
        LocalDateTime endCreateTime = query.getEndCreateTime();
        Map<String, List<Map<String, Object>>> resultMap = service.statisticalNumber(startCreateTime, endCreateTime);
        return TwOutputUtil.ok(resultMap);
    }

    /**
     * 查询时间段内的问题类型统计
     *
     * @param query
     * @return result
     */
    @ApiOperation("查询时间段内的问题类型统计")
    @GetMapping("/problemFeedback/statisticalGroupByProblemType")
    public TwOutputUtil findNumberStatisticalGroupByProblemType(PrdSystemProblemFeedbackQuery query) {
        LocalDateTime startCreateTime = query.getStartCreateTime();
        LocalDateTime endCreateTime = query.getEndCreateTime();
        List<Map<String, Object>> resultList = service.findNumberStatisticalGroupByProblemType(startCreateTime, endCreateTime);
        return TwOutputUtil.ok(resultList);
    }

    /**
     * 查询时间段内的问题所属功能统计
     *
     * @param query
     * @return result
     */
    @ApiOperation("查询时间段内的问题所属功能统计")
    @GetMapping("/problemFeedback/statisticalGroupByFunctionId")
    public TwOutputUtil findNumberStatisticalGroupByFunctionId(PrdSystemProblemFeedbackQuery query) {
        LocalDateTime startCreateTime = query.getStartCreateTime();
        LocalDateTime endCreateTime = query.getEndCreateTime();
        List<Map<String, Object>> resultList = service.findNumberStatisticalGroupByFunctionId(startCreateTime, endCreateTime);
        return TwOutputUtil.ok(resultList);
    }
}
