package com.elitesland.tw.tw5.server.prd.system.controller;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemProblemFeedbackProcessPayload;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemProblemFeedbackProcessService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemProblemFeedbackProcessVO;
import com.elitesland.tw.tw5.api.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import static com.elitesland.tw.tw5.server.prd.common.SystemConstants.API_SYSTEM;

/**
 * 系统功能处理-问题反馈处理过程
 * @author Lemon
 */
@Api("系统功能处理-问题反馈处理过程")
@RestController
@RequiredArgsConstructor
@RequestMapping(API_SYSTEM)
@Slf4j
public class PrdSystemProblemFeedbackProcessController {
    private final PrdSystemProblemFeedbackProcessService service;

    /**
     * 新建
     *
     * @param payload po类
     * @return result
     */
    @ApiOperation("新增")
    @PostMapping("/problemFeedbackProcess/insert")
    public TwOutputUtil insert(PrdSystemProblemFeedbackProcessPayload payload) {
        PrdSystemProblemFeedbackProcessVO vo = service.insert(payload);
        return TwOutputUtil.ok(vo);
    }
}
