package com.elitesland.tw.tw5.server.prd.system.controller;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemRemindPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemRemindQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRemindService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRemindVO;
import com.elitesland.tw.tw5.api.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

import static com.elitesland.tw.tw5.server.prd.common.SystemConstants.API_SYSTEM;

/**
 * 消息类管理
 *
 * @author wangding
 */
@Api("消息类处理")
@RestController
@RequiredArgsConstructor
@RequestMapping(API_SYSTEM)
@Slf4j
public class PrdSystemRemindController {

    private final PrdSystemRemindService service;
    private final CacheUtil cacheUtil;

    /**
     * 新建
     *
     * @param entity po类
     * @return result
     */
    @ApiOperation("新增")
    @PostMapping("/systemRemind")
    public TwOutputUtil insert(PrdSystemRemindPayload entity) {
        PrdSystemRemindVO vo = service.insert(entity);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 清空消息提醒缓存
     *
     * @return result
     */
    @ApiOperation("清空消息提醒缓存")
    @GetMapping("/systemRemind/clearCache")
    public TwOutputUtil clearCache() {
        cacheUtil.loadRemindCache();
        return TwOutputUtil.ok();
    }

    /**
     * 全部修改
     *
     * @param entity po类
     * @return result
     */
    @ApiOperation("修改")
    @PutMapping("/systemRemind/overall")
    public TwOutputUtil update(PrdSystemRemindPayload entity) {
        service.update(entity);
        return TwOutputUtil.ok();
    }

    /**
     * 物理删除
     *
     * @param keys 主键
     * @return result
     */
    @ApiOperation("物理删除")
    @DeleteMapping("/systemRemind")
    public TwOutputUtil delete(Long[] keys) {
        service.delete(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return result
     */
    @ApiOperation("逻辑删除")
    @PatchMapping("/systemRemind")
    public TwOutputUtil logicalDelete(Long[] keys) {
        service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 根据主键查询
     *
     * @param key 主键
     * @return result
     */
    @ApiOperation("主键查询")
    @GetMapping("/systemRemind/{key}")
    public TwOutputUtil findByKey(@PathVariable Long key) {
        PrdSystemRemindVO vo = service.queryByKey(key);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 分页查询
     *
     * @param query 查询条件
     * @return result
     */
    @ApiOperation("分页查询")
    @GetMapping("/systemRemind/paging")
    public TwOutputUtil findByConditionPaging(PrdSystemRemindQuery query) {
        PagingVO<PrdSystemRemindVO> paging = service.paging(query);
        return TwOutputUtil.ok(paging);
    }

    /**
     * 查询前端消息提醒
     *
     * @return result
     */
    @ApiOperation("查询前端消息提醒")
    @GetMapping("/systemRemind/portal")
    public TwOutputUtil findPortalList() {
        PrdSystemRemindQuery query = new PrdSystemRemindQuery();
        query.setPortalFlag(true);
        List<PrdSystemRemindVO> views = service.selectByCondition(query);
        return TwOutputUtil.ok(views);
    }
}
