package com.elitesland.tw.tw5.server.prd.system.controller;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemRolePayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemRoleQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRoleVO;
import com.elitesland.tw.tw5.api.common.TwOutputUtil;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 系统角色管理
 *
 * @author wangding
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/system")
@Slf4j
public class PrdSystemRoleController {

    private final PrdSystemRoleService service;

    /**
     * 新建
     *
     * @param entity po类
     * @return result
     */
    @PostMapping("/role/insert")
    public TwOutputUtil insert(@RequestBody PrdSystemRolePayload entity) {
        PrdSystemRoleVO vo = service.insert(entity);
        return TwOutputUtil.ok(vo);
    }


    /**
     * 状态修改
     *
     * @param id      主键
     * @param enabled 状态
     * @return result
     */
    @PutMapping("/role/updateStatus")
    public TwOutputUtil updateStatus(Long id, Boolean enabled) {
        service.updateStatus(id, enabled);
        return TwOutputUtil.ok();
    }

    /**
     * 修改
     *
     * @param entity po类
     * @return result
     */
    @PutMapping("/role/update")
    public TwOutputUtil update(@RequestBody PrdSystemRolePayload entity) {
        service.update(entity);
        return TwOutputUtil.ok();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return result
     */
    @DeleteMapping("/role/deleteSoft")
    public TwOutputUtil delete(Long[] keys) {
        service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }


    /**
     * 根据主键查询
     *
     * @param key 主键
     * @return result
     */
    @GetMapping("/role/{key}")
    public TwOutputUtil findByKey(@PathVariable Long key) {
        PrdSystemRoleVO vo = service.queryByKey(key);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 列表查询
     *
     * @return result
     */
    @ApiOperation("列表查询")
    @GetMapping("/role/list")
    public TwOutputUtil queryList() {
        List<PrdSystemRoleVO> paging = service.queryList();
        return TwOutputUtil.ok(paging);
    }

    /**
     * 分页查询
     *
     * @return result
     */
    @GetMapping("/role/paging")
    public TwOutputUtil usableList(PrdSystemRoleQuery query) {
        return TwOutputUtil.ok(service.paging(query));
    }

}
