package com.elitesland.tw.tw5.server.prd.system.controller;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemSettingPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemSettingQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemSettingService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSettingVO;
import com.elitesland.tw.tw5.api.common.TwOutputUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

import static com.elitesland.tw.tw5.server.prd.common.SystemConstants.API_SYSTEM;

/**
 * 系统设置项管理
 *
 * @author wangding
 */
@Api("系统设置项")
@RestController
@RequiredArgsConstructor
@RequestMapping(API_SYSTEM)
@Slf4j
public class PrdSystemSettingController {

    private final PrdSystemSettingService service;

    /**
     * 新建
     *
     * @param entity po类
     * @return result
     */
    @ApiOperation("新增")
    @PostMapping("/systemSetting")
    public TwOutputUtil insert(PrdSystemSettingPayload entity) {
        entity.setSettingKey(entity.getSettingKey().trim());
        entity.setSettingValue(entity.getSettingValue().trim());
        PrdSystemSettingVO vo = service.insert(entity);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 分页查询
     *
     * @param query 查询条件
     * @return result
     */
    @ApiOperation("分页查询")
    @GetMapping("/systemSetting/paging")
    public TwOutputUtil findByConditionPaging(PrdSystemSettingQuery query) {
        PagingVO<PrdSystemSettingVO> paging = service.paging(query);
        return TwOutputUtil.ok(paging);
    }

    /**
     * 列表查询
     *
     * @param query 查询条件
     * @return result
     */
    @ApiOperation("列表查询")
    @GetMapping("/systemSetting/list")
    public TwOutputUtil queryList(PrdSystemSettingQuery query) {
        List<PrdSystemSettingVO> paging = service.queryList(query);
        return TwOutputUtil.ok(paging);
    }

    /**
     * 物理删除
     *
     * @param keys 主键
     * @return result
     */
    @ApiOperation("物理删除")
    @DeleteMapping("/systemSetting")
    public TwOutputUtil delete(Long[] keys) {
        service.delete(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 全部修改
     *
     * @param entity po类
     * @return result
     */
    @ApiOperation("修改")
    @PutMapping("/systemSetting")
    public TwOutputUtil update(PrdSystemSettingPayload entity) {
        entity.setSettingKey(entity.getSettingKey().trim());
        entity.setSettingValue(entity.getSettingValue().trim());
        service.update(entity);
        return TwOutputUtil.ok();
    }


    /**
     * 根据主键查询
     *
     * @param key 主键
     * @return result
     */
    @ApiOperation("主键查询")
    @GetMapping("/systemSetting/{key}")
    public TwOutputUtil findByKey(@PathVariable Long key) {
        PrdSystemSettingVO vo = service.queryByKey(key);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 通过KEY获取系统设置
     *
     * @param key 下拉选择key
     * @return result
     */
    @ApiOperation("通过KEY获取系统设置")
    @GetMapping("/systemSetting/byKey/{key}")
    public TwOutputUtil getSystemSettingByKey(@PathVariable String key) {
        return TwOutputUtil.ok(service.getSystemSettingByKey(key));
    }

    /**
     * 清空消息提醒缓存
     *
     * @return result
     */
    @ApiOperation("清空消息提醒缓存")
    @GetMapping("/systemSetting/clearCache")
    public TwOutputUtil clearCache() {
        service.clearCache();
        return TwOutputUtil.ok();
    }

}
