package com.elitesland.tw.tw5.server.prd.system.controller;

import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemWorkTypeQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemWorkTypeService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemWorkTypeVO;
import com.elitesland.tw.tw5.api.common.TwOutputUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.Arrays;

/**
 * 人力资源管理
 *
 * @author wangding
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/system")
@Slf4j
public class PrdSystemWorkTypeController {

    private final PrdSystemWorkTypeService service;


    /**
     * 分页查询
     *
     * @param query 查询条件
     * @return result
     */
    @ApiOperation("分页查询")
    @GetMapping("/workType/paging")
    public TwOutputUtil findByConditionPaging(PrdSystemWorkTypeQuery query) {
        PagingVO<PrdSystemWorkTypeVO> paging = service.paging(query);
        return TwOutputUtil.ok(paging);
    }

    /**
     * 列表查询
     *
     * @return result
     */
    @ApiOperation("列表查询")
    @GetMapping("/workType/list")
    public TwOutputUtil queryList() {
        return TwOutputUtil.ok(service.queryList());
    }

    /**
     * 物理删除
     *
     * @param keys 主键
     * @return result
     */
    @ApiOperation("物理删除")
    @DeleteMapping("/workType")
    public TwOutputUtil delete(Long[] keys) {
        service.delete(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 修改
     *
     * @return result
     */
    @ApiOperation("修改")
    @PutMapping("/workType")
    public TwOutputUtil update(Long key, String sysType, String sysWork, String sysLevel, BigDecimal unitPrice) {
        service.update(key, sysType, sysWork, sysLevel, unitPrice);
        return TwOutputUtil.ok();
    }

    /**
     * 批量导出excel
     *
     * @return result
     */
    @ApiOperation("批量导出excel")
    @GetMapping("/workType/batchExport")
    public void batchExport(HttpServletResponse response, PrdSystemWorkTypeQuery query) {
        service.downloadPlus(response, query);
    }

    /**
     * 批量导入excel
     *
     * @return result
     */
    @ApiOperation("批量导入excel")
    @PostMapping(value = "/workType/batchImport", consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    @Transactional
    public TwOutputUtil batchImport(MultipartFile file) {
        service.importWorkType(file);
        return TwOutputUtil.ok();
    }
}
