package com.elitesland.tw.tw5.server.prd.system.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

@Entity
@Table(name = "prd_sysytem_work_type")
@org.hibernate.annotations.Table(appliesTo = "prd_sysytem_work_type", comment = "工种类型表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdSystemWorkTypeDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 1L;


    @Comment("类型")
    @Column()
    private String sysType;

    @Comment("工种")
    @Column()
    private String sysWork;

    @Comment("等级")
    @Column()
    private String sysLevel;

    @Comment("单价")
    @Column()
    private BigDecimal unitPrice;

    public PrdSystemWorkTypeDO() {
    }

    public PrdSystemWorkTypeDO(String sysType, String sysWork, String sysLevel, BigDecimal unitPrice) {
        this.sysType = sysType;
        this.sysWork = sysWork;
        this.sysLevel = sysLevel;
        this.unitPrice = unitPrice;
    }
}
