package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitesland.tw.tw5.api.common.TwException;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemRolePayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemRoleQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRoleVO;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemRoleConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemRoleDO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemRoleMenuDO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemUserRoleDO;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 菜单管理service
 *
 * @author wangding
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdSystemRoleServiceImpl implements PrdSystemRoleService {
    private final PrdSystemRoleDAO dao;

    @Transactional
    @Override
    public PrdSystemRoleVO insert(PrdSystemRolePayload payload) {
        if (dao.queryByCode(payload.getRoleCode()) != null) {
            throw TwException.error("", "编号不可重复");
        }
        PrdSystemRoleDO ado = PrdSystemRoleConvert.INSTANCE.toDo(payload);
        ado = dao.save(ado);
        if (payload.getMenuIds() != null && payload.getMenuIds().size() > 0) {
            List<PrdSystemRoleMenuDO> roleMenuDOS = new ArrayList<>();
            for (Long menuId : payload.getMenuIds()) {
                PrdSystemRoleMenuDO roleMenuDO = new PrdSystemRoleMenuDO();
                roleMenuDO.setMenuId(menuId);
                roleMenuDO.setRoleId(ado.getId());
                roleMenuDOS.add(roleMenuDO);
            }
            dao.saveRoleMenuAll(roleMenuDOS);
        }
        if (payload.getUserIds() != null && payload.getUserIds().size() > 0) {
            List<PrdSystemUserRoleDO> userDOS = new ArrayList<>();
            for (Long userId : payload.getUserIds()) {
                PrdSystemUserRoleDO userDO = new PrdSystemUserRoleDO();
                userDO.setUserId(userId);
                userDO.setRoleId(ado.getId());
                userDOS.add(userDO);
            }
            dao.saveUserRoleAll(userDOS);
        }

        return PrdSystemRoleConvert.INSTANCE.toVo(ado);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public PrdSystemRoleVO insertByTenant(PrdSystemRolePayload payload) {
        if (dao.queryByCode(payload.getRoleCode()) != null) {
            throw TwException.error("", "编号不可重复");
        }
        PrdSystemRoleDO ado = PrdSystemRoleConvert.INSTANCE.toDo(payload);
        // 租户初始化数据
        if (null != payload.getInitTenantId()) {
            ado.setTenantId(payload.getInitTenantId());
        }
        ado = dao.save(ado);
        if (payload.getMenuIds() != null && payload.getMenuIds().size() > 0) {
            List<PrdSystemRoleMenuDO> roleMenuDOS = new ArrayList<>();
            for (Long menuId : payload.getMenuIds()) {
                PrdSystemRoleMenuDO roleMenuDO = new PrdSystemRoleMenuDO();
                roleMenuDO.setMenuId(menuId);
                roleMenuDO.setRoleId(ado.getId());
                // 租户初始化数据
                if (null != payload.getInitTenantId()) {
                    roleMenuDO.setTenantId(payload.getInitTenantId());
                }
                roleMenuDOS.add(roleMenuDO);
            }
            dao.saveRoleMenuAll(roleMenuDOS);
        }
        if (payload.getUserIds() != null && payload.getUserIds().size() > 0) {
            List<PrdSystemUserRoleDO> userDOS = new ArrayList<>();
            for (Long userId : payload.getUserIds()) {
                PrdSystemUserRoleDO userDO = new PrdSystemUserRoleDO();
                userDO.setUserId(userId);
                userDO.setRoleId(ado.getId());
                // 租户初始化数据
                if (null != payload.getInitTenantId()) {
                    userDO.setTenantId(payload.getInitTenantId());
                }
                userDOS.add(userDO);
            }
            dao.saveUserRoleAll(userDOS);
        }

        return PrdSystemRoleConvert.INSTANCE.toVo(ado);
    }

    @Transactional
    @Override
    public Long update(PrdSystemRolePayload payload) {
        PrdSystemRoleVO roleVO = dao.queryByCode(payload.getRoleCode());
        if (roleVO != null && roleVO.getId().longValue() != payload.getId().longValue()) {
            throw TwException.error("", "编号不可重复");
        }
        dao.updateByKeyDynamic(payload);
        if (payload.getMenuIds() != null) {
            if (payload.getMenuIds().size() > 0) {
                List<PrdSystemRoleMenuDO> roleMenuDOS = new ArrayList<>();
                for (Long menuId : payload.getMenuIds()) {
                    PrdSystemRoleMenuDO roleMenuDO = new PrdSystemRoleMenuDO();
                    roleMenuDO.setMenuId(menuId);
                    roleMenuDO.setRoleId(payload.getId());
                    roleMenuDOS.add(roleMenuDO);
                }
                dao.deleteRoleMenusByRoleId(payload.getId());
                dao.saveRoleMenuAll(roleMenuDOS);
            } else {
                dao.deleteRoleMenusByRoleId(payload.getId());
            }

        }
        if (payload.getUserIds() != null) {
            if (payload.getUserIds().size() > 0) {
                List<PrdSystemUserRoleDO> userDOS = new ArrayList<>();
                for (Long userId : payload.getUserIds()) {
                    PrdSystemUserRoleDO userDO = new PrdSystemUserRoleDO();
                    userDO.setUserId(userId);
                    userDO.setRoleId(payload.getId());
                    userDOS.add(userDO);
                }
                dao.deleteRolesByUserId(payload.getId());
                dao.saveUserRoleAll(userDOS);
            } else {
                dao.deleteRolesByUserId(payload.getId());
            }
        }
        return 0L;
    }

    @Transactional
    @Override
    public Long updateStatus(Long id, Boolean enabled) {
        if (!ObjectUtils.isEmpty(id) && !ObjectUtils.isEmpty(enabled)) {
            dao.updateStatus(id, enabled);
            return 0L;
        } else {
            throw TwException.error("", "参数错误");
        }
    }


    @Transactional
    @Override
    public boolean deleteSoft(List<Long> keys) {
        dao.deleteSoft(keys);
        return true;
    }

    @Override
    public PrdSystemRoleVO queryByKey(Long key) {
        PrdSystemRoleVO roleVO = dao.queryByKey(key);
        roleVO.setMenuIds(dao.queryRoleMenuIds(key));
        roleVO.setUserDatas(dao.queryUsers(key));
        return roleVO;
    }

    @Override
    public PagingVO<PrdSystemRoleVO> paging(PrdSystemRoleQuery query) {
        return dao.queryPaging(query);
    }

    @Override
    public List<PrdSystemRoleVO> queryList() {
        return dao.queryList();
    }
}
