package com.elitesland.tw.tw5.server.prd.work.controller;

import com.elitesland.tw.tw5.api.prd.work.payload.PrdWorkAssignmentPayload;
import com.elitesland.tw.tw5.api.prd.work.query.PrdWorkAssignmentQuery;
import com.elitesland.tw.tw5.api.prd.work.service.PrdWorkAssignmentService;
import com.elitesland.tw.tw5.api.prd.work.vo.PrdWorkAssignmentVO;
import com.elitesland.tw.tw5.api.common.TwOutputUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

@Api("系统功能处理-指派")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/work")
@Slf4j
public class PrdWorkAssignmentController {

    private final PrdWorkAssignmentService service;

    /**
     * 新建
     *
     * @param entity po类
     * @return result
     */
    @ApiOperation("新增")
    @PostMapping("/assignment/insert")
    public TwOutputUtil insert(PrdWorkAssignmentPayload entity) {
        PrdWorkAssignmentVO vo = service.insert(entity);
        return TwOutputUtil.ok(vo);
    }


    /**
     * 根据主键动态修改
     *
     * @param payload po类
     * @return result
     */
    @ApiOperation("根据主键动态修改")
    @PutMapping("/assignment/updateByKeyDynamic")
    public TwOutputUtil updateByKeyDynamic(PrdWorkAssignmentPayload payload) {
        Long returnNum = service.updateByKeyDynamic(payload);
        if (returnNum < 0) {
            return TwOutputUtil.error().addError("", "", null);
        } else {
            return TwOutputUtil.ok();
        }
    }

    /**
     * 分页查询
     *
     * @param query 查询条件
     * @return
     */
    @ApiOperation("分页查询")
    @GetMapping("/assignment/paging")
    public TwOutputUtil paging(PrdWorkAssignmentQuery query) {
        PagingVO<PrdWorkAssignmentVO> paging = service.paging(query);
        return TwOutputUtil.ok(paging);
    }

    /**
     * 主键查询
     *
     * @param key 主键
     * @return
     */
    @ApiOperation("主键查询")
    @GetMapping("/assignment/{key}")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        PrdWorkAssignmentVO vo = service.queryByKey(key);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 开始
     *
     * @param ids 主键
     * @return
     */
    @ApiOperation("开始")
    @PutMapping("/assignment/start")
    public TwOutputUtil start(Long[] ids) {
        service.start(Arrays.asList(ids));
        return TwOutputUtil.ok();
    }

    /**
     * 暂挂
     *
     * @param ids 主键
     * @return
     */
    @ApiOperation("暂挂")
    @PutMapping("/assignment/pending")
    public TwOutputUtil pending(Long[] ids) {
        service.pending(Arrays.asList(ids));
        return TwOutputUtil.ok();
    }

    /**
     * 完成
     *
     * @param ids 主键
     * @return
     */
    @ApiOperation("完成")
    @PutMapping("/assignment/finish")
    public TwOutputUtil finish(Long[] ids) {
        service.finish(Arrays.asList(ids));
        return TwOutputUtil.ok();
    }

    /**
     * 关闭
     *
     * @param ids 主键
     * @return
     */
    @ApiOperation("关闭")
    @PutMapping("/assignment/close")
    public TwOutputUtil close(Long[] ids) {
        service.close(Arrays.asList(ids));
        return TwOutputUtil.ok();
    }

    /**
     * 列表查询
     *
     * @param query
     * @return
     */
    @ApiOperation("列表查询")
    @GetMapping("/assignment/queryList")
    public TwOutputUtil queryList(PrdWorkAssignmentQuery query) {
        List<PrdWorkAssignmentVO> voList = service.queryList(query);
        return TwOutputUtil.ok(voList);
    }

    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return result
     */
    @ApiOperation("逻辑删除")
    @DeleteMapping("/assignment/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys) {
        service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }
}
