package com.elitesland.tw.tw5.server.tenant.controller;

import com.elitesland.tw.tw5.api.common.TwOutputUtil;
import com.elitesland.tw.tw5.api.tenant.payload.AuthTenantPayload;
import com.elitesland.tw.tw5.api.tenant.query.AuthTenantQuery;
import com.elitesland.tw.tw5.api.tenant.service.AuthTenantService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 租户授权
 *
 * @author duwh
 * @date 2023-04-02
 */
@Api(tags = "租户授权")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/tenant/authTenant")
@Slf4j
public class AuthTenantController {

    private final AuthTenantService authTenantService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("新增")
    public TwOutputUtil insert(@RequestBody AuthTenantPayload payload){
        return TwOutputUtil.ok(authTenantService.insert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("更新")
    public TwOutputUtil update(@RequestBody AuthTenantPayload payload){
        return TwOutputUtil.ok(authTenantService.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(authTenantService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("分页")
    public TwOutputUtil paging(AuthTenantQuery query) {
        return TwOutputUtil.ok(authTenantService.queryPaging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("查询列表")
    public TwOutputUtil queryList(AuthTenantQuery query) {
        return TwOutputUtil.ok(authTenantService.queryListDynamic(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        authTenantService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
