package com.elitesland.tw.tw5.server.tenant.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 租户授权
 *
 * @author duwh
 * @date 2023-04-02
 */
@Entity
@Table(name = "auth_tenant", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "auth_tenant", comment = "租户授权")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
@ToString
public class AuthTenantDO extends BaseModel implements Serializable  {
    /** 授权租户数据 */
    @Comment("授权租户数据")
    @Column()
    private Long authTenantId;
    /** 授权模块 UDC 下拉选择项 */
    @Comment("授权模块 UDC 下拉选择项")
    @Column()
    private String authType;

    public void copy(AuthTenantDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
