package com.elitesland.tw.tw5.server.udc;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.udc.UdcName;
import com.elitesland.tw.tw5.api.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 翻译切面 包含 系统选择项、用户、组织
 *
 * @author duwh
 * @date 2022/11/16
 */
@Aspect
@Component
@Slf4j
public class UdcAspect {

    private final CacheUtil cacheUtil;

    private final static String COLLECTION_FIELD_TYPE = "Collection";

    public UdcAspect(CacheUtil cacheUtil) {
        this.cacheUtil = cacheUtil;
    }

    //@Pointcut("@annotation(udcNameClass)")
    //public void doDataDictClass(UdcNameClass udcNameClass) {
    //}

    @Around("@annotation(udcNameClass)")
    public Object translation(final ProceedingJoinPoint pjp, UdcNameClass udcNameClass) throws Throwable {
        Object resultR = pjp.proceed();
        if (ObjectUtil.isNull(resultR)) {
            return resultR;
        }
        if (resultR instanceof TwOutputUtil) {
            return translation((TwOutputUtil) resultR);
        }
        return resultR;
    }

    public TwOutputUtil translation(final TwOutputUtil twOutput) {
        Object data = twOutput.getData();
        if (data instanceof PagingVO) {
            List list = ((PagingVO) data).getRecords();
            translate(list);
        } else {
            translate(data);
        }
        return twOutput;
    }

    private Object translate(Object result) {
        Object obj;
        final boolean collectionFlag = result instanceof List<?>;
        if (collectionFlag) {
            List olist = ((List) result);
            if (olist.size() == 0) {
                return result;
            }
            obj = olist.get(0);
        } else {
            obj = result;
        }
        if (null != obj) {
            // 获取所有配置注解的code 和实体字段
            List<UdcDTO> udcParams = getUdcMapping(obj, obj.getClass(), null, null);
            if (udcParams.size() == 0) {
                return result;
            }
            if (collectionFlag) {
                for (Object entity : (List) result) {
                    assign(entity, udcParams);
                }
            } else {
                assign(result, udcParams);
            }
        }
        return result;
    }

    public void assign(Object entity, List<UdcDTO> dictParams) {
        // 处理对象中集合
        List<UdcDTO> listTypeUdc = dictParams.stream()
            .filter(udcDTO ->
                StringUtils.hasText(udcDTO.getType())
                    && udcDTO.getType().equals(COLLECTION_FIELD_TYPE)).collect(Collectors.toList());
        final List<String> listFieldKeys = listTypeUdc.stream().map(UdcDTO::getListFieldName).distinct().collect(Collectors.toList());

        for (String listFieldKey : listFieldKeys) {
            try {
                Class c = entity.getClass();
                if (c != null) {
                    // 集合对象
                    Field f = c.getDeclaredField(listFieldKey);
                    f.setAccessible(true);
                    // 集合的值
                    Object preValue = f.get(entity);
                    if (ObjectUtil.isNotNull(preValue)) {
                        Collection list = (Collection) preValue;
                        for (Object obj : list) {
                            // 循环翻译集合值
                            for (UdcDTO dictParam : listTypeUdc) {
                                translation(obj, dictParam);
                            }
                        }
                        f.set(entity, list);
                    }
                }
            } catch (Exception e) {
                log.error("[UDC翻译异常]:{}", e.getMessage(), e);
            }
        }

        // 普通类型 字段翻译
        final List<UdcDTO> generalTypeUdc = dictParams.stream()
            .filter(udcDTO ->
                !(StringUtils.hasText(udcDTO.getType())
                    && StringUtils.hasText(udcDTO.getListFieldName())
                )
            ).collect(Collectors.toList());
        for (UdcDTO dictParam : generalTypeUdc) {
            translation(entity, dictParam);
        }
    }

    private void translation(Object entity, UdcDTO dictParam) {
        String selectionKey = dictParam.getUdcName();
        // 翻译依据的值
        String codePropName = dictParam.getCodePropName();
        // 需要赋值的字段
        String filedName = dictParam.getFieldName();
        try {
            Class c = entity.getClass();
            if (c != null) {
                Field f = c.getDeclaredField(codePropName);
                f.setAccessible(true);
                // udc 翻译之前的值
                Object preValue = f.get(entity);
                if (ObjectUtil.isNotNull(preValue)) {
                    // 需要赋值的字段
                    Field fValue = c.getDeclaredField(filedName);
                    fValue.setAccessible(true);
                    // 用户翻译
                    if (selectionKey.equals(UdcTypeEnum.USER.getCode())) {
                        fValue.set(entity, cacheUtil.getUserName(Long.valueOf(preValue.toString())));
                        // 组织部门翻译
                    } else if (selectionKey.equals(UdcTypeEnum.BU.getCode())) {
                        fValue.set(entity, cacheUtil.getOrgName(Long.valueOf(preValue.toString())));
                    } else {
                        // udc  系统选择项翻译
                        fValue.set(entity, cacheUtil.transferSystemSelection(selectionKey, preValue.toString()));
                    }
                }
            }
        } catch (Exception e) {
            log.error("[UDC翻译异常]:{}", e.getMessage(), e);
        }
    }

    /**
     * 获取实体中配置的udc 和对应的字段内容
     *
     * @param cla
     * @return
     */
    private List<UdcDTO> getUdcMapping(Object entity, Class cla, String listFieldName, String fieldType) {
        Field[] fields = cla.getDeclaredFields();
        List<UdcDTO> list = new ArrayList<>();
        UdcDTO udcDto;
        UdcName udcName;
        for (Field field : fields) {
            final Class<?> type = field.getType();
            if ((Collection.class.isAssignableFrom(type))) {
                // 集合属性key
                final String name = field.getName();
                try {
                    Field f = cla.getDeclaredField(name);
                    f.setAccessible(true);
                    Object obj = f.get(entity);
                    if (null != obj) {
                        if (obj instanceof List<?>) {
                            List olist = ((List) obj);
                            if (olist.size() > 0) {
                                obj = olist.get(0);
                                final Class<?> aClass = obj.getClass();
                                list.addAll(getUdcMapping(obj, aClass, name, COLLECTION_FIELD_TYPE));
                            }
                        }
                    }
                } catch (Exception e) {
                    log.error("UDC 翻译异常-子集合：{}", e.getMessage(), e);
                }
            }
            if (field.isAnnotationPresent(UdcName.class)) {
                udcName = field.getAnnotation(UdcName.class);
                udcDto = new UdcDTO(udcName.udcName(), udcName.codePropName(), field.getName());
                udcDto.setListFieldName(listFieldName);
                udcDto.setType(fieldType);
                list.add(udcDto);
            }
        }
        return list;
    }


}
