/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.common;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitesland.tw.tw5.api.common.util.TreeListUtil;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDataRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemFunctionDataQuery;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemFunctionQuery;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemFunctionSpecialQuery;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemRemindQuery;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemSelectionQuery;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemSettingQuery;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemTagQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemConfigVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFunctionDataVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFunctionSpecialVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFunctionVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRemindVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSettingVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemShortcutVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemTagVO;
import com.elitesland.tw.tw5.server.common.util.RedisUtils;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.my.dao.PrdUserDAO;
import com.elitesland.tw.tw5.server.prd.org.convert.PrdOrgEmployeeConvert;
import com.elitesland.tw.tw5.server.prd.org.convert.PrdOrgOrganizationConvert;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemConfigDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemFunctionDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemFunctionDataDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemFunctionSpecialDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRemindDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemSelectionDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemSettingDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemTagDAO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Component
public class CacheUtil {
    private final PrdSystemRemindDAO systemRemindDAO;
    private final PrdSystemSelectionDAO prdSystemSelectionDAO;
    private final PrdSystemTagDAO prdSystemTagDAO;
    private final PrdSystemSettingDAO prdSystemSettingDAO;
    private final RedisUtils redisUtils;
    private final PrdSystemFunctionDAO prdSystemFunctionDAO;
    private final PrdSystemFunctionSpecialDAO prdSystemFunctionSpecialDAO;
    private final PrdSystemFunctionDataDAO prdSystemFunctionDataDAO;
    private final PrdSystemConfigDAO prdSystemConfigDAO;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final PrdOrgOrganizationDAO orgOrganizationDAO;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final PrdUserDAO prdUserDAO;
    private final Map<Long, String> userRoleMaps = new HashMap<Long, String>();
    private final Map<String, List<Long>> roleUserMaps = new HashMap<String, List<Long>>();
    private final Map<String, PrdSystemRemindVO> remindCacheMap = new HashMap<String, PrdSystemRemindVO>();
    private final Map<String, PrdSystemSelectionVO> systemSelectionCacheMap = new HashMap<String, PrdSystemSelectionVO>();
    private final List<PrdSystemTagVO> systemTagCacheMap = new ArrayList<PrdSystemTagVO>();
    private final Map<String, PrdSystemSettingVO> systemSettingCacheMap = new HashMap<String, PrdSystemSettingVO>();
    private final Map<String, PrdSystemFunctionVO> systemFunctionCacheMap = new HashMap<String, PrdSystemFunctionVO>();
    private final Map<Long, PrdSystemFunctionVO> systemFunctionCacheMap0 = new HashMap<Long, PrdSystemFunctionVO>();
    private final Map<String, PrdSystemFunctionSpecialVO> systemFunctionSpecialCacheMap = new HashMap<String, PrdSystemFunctionSpecialVO>();
    private final Map<Long, List<PrdSystemFunctionDataVO>> systemFunctionDataCacheMap = new HashMap<Long, List<PrdSystemFunctionDataVO>>();
    private final Map<String, PrdSystemConfigVO> systemConfigCacheMap = new HashMap<String, PrdSystemConfigVO>();
    private final Map<Long, PrdOrgEmployeeVO> employeeCacheMap = new HashMap<Long, PrdOrgEmployeeVO>();
    private static final String ORGANIZATION_CACHE_KEY = "ORGANIZATION_CACHE_KEY";
    private static final String EMPLOYEES_ORGANIZATION_CACHE_KEY = "EMPLOYEES_ORGANIZATION_CACHE_KEY";
    private static final String EMPLOYEES_DEFAULT_ORGANIZATION_INFO_CACHE_KEY = "EMPLOYEES_DEFAULT_ORGANIZATION_INFO_CACHE_KEY";
    private static final String EMPLOYEES_CACHE_KEY = "EMPLOYEES_CACHE_KEY";
    private static final String EMPLOYEES_CACHE_KEY_MOBILE = "EMPLOYEES_CACHE_MOBILE_KEY";
    private static final String EMPLOYEES_MANAGER_ORG_KEY = "EMPLOYEES_MANAGER_ORG_KEY";
    private static final String EMPLOYEES_MY_ORG_KEY = "EMPLOYEES_MY_ORG_KEY";
    private static final String EMPLOYEES_MANAGER_SUBORDINATES_KEY = "EMPLOYEES_MANAGER_SUBORDINATES_KEY";
    private final List<PrdSystemShortcutVO> systemShortcutCache = new ArrayList<PrdSystemShortcutVO>();
    private static long lastLoadTimeRemind = 0L;
    private static long lastLoadTimeSystemSelection = 0L;
    private static long lastLoadTimeSystemSetting = 0L;
    private static long lastLoadTimeSystemFunction = 0L;
    private static long lastLoadTimeSystemFunctionSpecial = 0L;
    private static long lastLoadTimeSystemFunctionData = 0L;
    private static long lastLoadTimeSystemConfig = 0L;
    private static long lastLoadTimeSystemTag = 0L;
    private static long lastLoadTimeSystemRole = 0L;

    public void loadSystemTagCache() {
        this.systemTagCacheMap.clear();
        List<PrdSystemTagVO> functionVOs = this.prdSystemTagDAO.queryListDynamic(new PrdSystemTagQuery());
        functionVOs.forEach(functionVO -> this.systemTagCacheMap.add((PrdSystemTagVO)functionVO));
        lastLoadTimeSystemTag = new Date().getTime();
    }

    public List<PrdSystemTagVO> getSystemTag(Long id) {
        if (id == null) {
            if ((this.systemTagCacheMap == null || this.systemTagCacheMap.size() == 0) && this.shouldLoadCache(lastLoadTimeSystemTag)) {
                this.loadSystemTagCache();
            }
            return this.systemTagCacheMap;
        }
        List<PrdSystemTagVO> functionVOs = this.systemTagCacheMap.stream().filter(systemTag -> systemTag.getId().longValue() == id.longValue()).collect(Collectors.toList());
        if ((functionVOs == null || functionVOs.size() == 0) && this.shouldLoadCache(lastLoadTimeSystemTag)) {
            this.loadSystemTagCache();
            List<PrdSystemTagVO> functionVO0 = this.systemTagCacheMap.stream().filter(systemTag -> systemTag.getId().longValue() == id.longValue()).collect(Collectors.toList());
            return functionVO0;
        }
        return functionVOs;
    }

    public void loadSystemConfigCache() {
        this.systemConfigCacheMap.clear();
        List<PrdSystemConfigVO> functionVOs = this.prdSystemConfigDAO.queryListDynamic();
        functionVOs.forEach(functionVO -> this.systemConfigCacheMap.put(functionVO.getConfigCode(), (PrdSystemConfigVO)functionVO));
        lastLoadTimeSystemConfig = new Date().getTime();
    }

    public PrdSystemConfigVO getSystemConfig(String code) {
        PrdSystemConfigVO functionVO = this.systemConfigCacheMap.get(code);
        if (functionVO == null && this.shouldLoadCache(lastLoadTimeSystemConfig)) {
            this.loadSystemConfigCache();
            return this.systemConfigCacheMap.get(code);
        }
        return functionVO;
    }

    public void loadSystemFunctionDataCache() {
        this.systemFunctionDataCacheMap.clear();
        PrdSystemFunctionDataQuery query = new PrdSystemFunctionDataQuery();
        List<PrdSystemFunctionDataVO> functionVOs = this.prdSystemFunctionDataDAO.queryListDynamic(query);
        functionVOs.forEach(functionVO -> {
            Long functionId = functionVO.getFunctionId();
            List<PrdSystemFunctionDataVO> list = this.systemFunctionDataCacheMap.get(functionId);
            if (list != null && list.size() > 0) {
                list.add((PrdSystemFunctionDataVO)functionVO);
            } else {
                list = new ArrayList<PrdSystemFunctionDataVO>();
                list.add((PrdSystemFunctionDataVO)functionVO);
                this.systemFunctionDataCacheMap.put(functionId, list);
            }
        });
        lastLoadTimeSystemFunctionData = new Date().getTime();
    }

    public List<PrdSystemFunctionDataVO> getFunctionData(Long functionId) {
        List<PrdSystemFunctionDataVO> list = this.systemFunctionDataCacheMap.get(functionId);
        if (list == null && this.shouldLoadCache(lastLoadTimeSystemFunctionData)) {
            this.loadSystemFunctionDataCache();
            return this.systemFunctionDataCacheMap.get(functionId);
        }
        return list;
    }

    public void loadSystemFunctionSpecialCache() {
        this.systemFunctionSpecialCacheMap.clear();
        PrdSystemFunctionSpecialQuery query = new PrdSystemFunctionSpecialQuery();
        List<PrdSystemFunctionSpecialVO> functionVOs = this.prdSystemFunctionSpecialDAO.queryListDynamic(query);
        functionVOs.forEach(functionVO -> this.systemFunctionSpecialCacheMap.put(functionVO.getSpecialUrl(), (PrdSystemFunctionSpecialVO)functionVO));
        lastLoadTimeSystemFunctionSpecial = new Date().getTime();
    }

    public PrdSystemFunctionSpecialVO getFunctionSpecial(String url) {
        PrdSystemFunctionSpecialVO functionVO = this.systemFunctionSpecialCacheMap.get(url);
        if (functionVO == null && this.shouldLoadCache(lastLoadTimeSystemFunctionSpecial)) {
            this.loadSystemFunctionSpecialCache();
            return this.systemFunctionSpecialCacheMap.get(url);
        }
        return functionVO;
    }

    public void loadSystemFunctionCache() {
        this.systemFunctionCacheMap.clear();
        this.systemFunctionCacheMap0.clear();
        PrdSystemFunctionQuery query = new PrdSystemFunctionQuery();
        List<PrdSystemFunctionVO> functionVOs = this.prdSystemFunctionDAO.queryListDynamic(query);
        functionVOs.forEach(functionVO -> {
            this.systemFunctionCacheMap.put(functionVO.getFunctionCode(), (PrdSystemFunctionVO)functionVO);
            this.systemFunctionCacheMap0.put(functionVO.getId(), (PrdSystemFunctionVO)functionVO);
        });
        TreeListUtil.toTree(functionVOs);
        lastLoadTimeSystemFunction = new Date().getTime();
    }

    public PrdSystemFunctionVO getFunctionById(Long id) {
        PrdSystemFunctionVO functionVO = this.systemFunctionCacheMap0.get(id);
        if (functionVO == null && this.shouldLoadCache(lastLoadTimeSystemFunction)) {
            this.loadSystemFunctionCache();
            return this.systemFunctionCacheMap0.get(id);
        }
        return functionVO;
    }

    public PrdSystemFunctionVO getFunction(String functionCode) {
        PrdSystemFunctionVO functionVO = this.systemFunctionCacheMap.get(functionCode);
        if (functionVO == null && this.shouldLoadCache(lastLoadTimeSystemFunction)) {
            this.loadSystemFunctionCache();
            return this.systemFunctionCacheMap.get(functionCode);
        }
        return functionVO;
    }

    public void loadRemindCache() {
        this.remindCacheMap.clear();
        PrdSystemRemindQuery query = new PrdSystemRemindQuery();
        List<PrdSystemRemindVO> remindViews = this.systemRemindDAO.queryListDynamic(query);
        remindViews.forEach(remindView -> this.remindCacheMap.put(remindView.getRemindCode(), (PrdSystemRemindVO)remindView));
        lastLoadTimeRemind = new Date().getTime();
    }

    public PrdSystemRemindVO getRemind(String remindCode) {
        PrdSystemRemindVO remindView = this.remindCacheMap.get(remindCode);
        if (remindView == null && this.shouldLoadCache(lastLoadTimeRemind)) {
            this.loadRemindCache();
            return this.remindCacheMap.get(remindCode);
        }
        return remindView;
    }

    private boolean shouldLoadCache(long lastLoadTime) {
        long interval = 60000L;
        return new Date().getTime() - lastLoadTime > interval;
    }

    public void loadSystemSelectionCache() {
        this.systemSelectionCacheMap.clear();
        PrdSystemSelectionQuery query = new PrdSystemSelectionQuery();
        List<PrdSystemSelectionVO> selectionViews = this.prdSystemSelectionDAO.queryListDynamic(query);
        selectionViews.forEach(selectionView -> this.systemSelectionCacheMap.put(selectionView.getSelectionKey(), (PrdSystemSelectionVO)selectionView));
        TreeListUtil.toTree(selectionViews);
        lastLoadTimeSystemSelection = new Date().getTime();
    }

    public String transferSystemSelection(String selectionKey, String value) {
        if (value == null) {
            return null;
        }
        PrdSystemSelectionVO selection = this.getSystemSelection(selectionKey);
        String result = value;
        if (selection == null) {
            return result;
        }
        ArrayList<PrdSystemSelectionVO> children = new ArrayList<PrdSystemSelectionVO>();
        this.getAllChildren(selection, children);
        if (children != null && children.size() > 0) {
            for (PrdSystemSelectionVO selectionView : children) {
                if (!value.equals(selectionView.getSelectionValue())) continue;
                result = selectionView.getSelectionName();
            }
        }
        return result;
    }

    public PrdSystemSelectionVO transferSystemObjByName(String selectionKey, String name) {
        if (name == null) {
            return null;
        }
        PrdSystemSelectionVO selection = this.getSystemSelection(selectionKey);
        if (selection == null) {
            return null;
        }
        ArrayList<PrdSystemSelectionVO> children = new ArrayList<PrdSystemSelectionVO>();
        this.getAllChildren(selection, children);
        if (children != null && children.size() > 0) {
            for (PrdSystemSelectionVO selectionView : children) {
                if (!name.equals(selectionView.getSelectionName())) continue;
                selection = selectionView;
                break;
            }
        }
        return selection;
    }

    public PrdSystemSelectionVO transferSystemSelectionObj(String selectionKey) {
        PrdSystemSelectionVO selection = this.getSystemSelection(selectionKey);
        if (selection == null) {
            return null;
        }
        ArrayList<PrdSystemSelectionVO> children = new ArrayList<PrdSystemSelectionVO>();
        this.getAllChildren(selection, children);
        return selection;
    }

    public PrdSystemSelectionVO transferSystemSelectionObj(String selectionKey, String value) {
        if (value == null) {
            return null;
        }
        PrdSystemSelectionVO selection = this.getSystemSelection(selectionKey);
        if (selection == null) {
            return null;
        }
        ArrayList<PrdSystemSelectionVO> children = new ArrayList<PrdSystemSelectionVO>();
        this.getAllChildren(selection, children);
        if (children != null && children.size() > 0) {
            for (PrdSystemSelectionVO selectionView : children) {
                if (!value.equals(selectionView.getSelectionValue())) continue;
                return selectionView;
            }
        }
        return null;
    }

    public void getAllChildren(PrdSystemSelectionVO parent, List<PrdSystemSelectionVO> allChildren) {
        if (CollectionUtils.isEmpty((Collection)parent.getChildren())) {
            return;
        }
        allChildren.addAll(parent.getChildren());
        for (PrdSystemSelectionVO child : parent.getChildren()) {
            this.getAllChildren(child, allChildren);
        }
    }

    public String getSystemSelectionValueByName(String selectionKey, String name) {
        if (!StringUtils.hasText((String)name)) {
            return null;
        }
        name = name.trim();
        PrdSystemSelectionVO selection = this.getSystemSelection(selectionKey);
        String result = name;
        if (selection == null) {
            return result;
        }
        List children = selection.getChildren();
        if (children != null && children.size() > 0) {
            for (PrdSystemSelectionVO selectionView : children) {
                if (!name.equals(selectionView.getSelectionName())) continue;
                result = selectionView.getSelectionValue();
            }
        }
        return result;
    }

    public Integer transferSystemSelectionSortIndex(String selectionKey, String value) {
        if (value == null) {
            return null;
        }
        PrdSystemSelectionVO selection = this.getSystemSelection(selectionKey);
        Integer result = 0;
        if (selection == null) {
            return result;
        }
        List children = selection.getChildren();
        if (children != null && children.size() > 0) {
            for (PrdSystemSelectionVO selectionView : children) {
                if (!value.equals(selectionView.getSelectionValue())) continue;
                result = selectionView.getSortNo() == null ? 0 : selectionView.getSortNo();
            }
        }
        return result;
    }

    public PrdSystemSelectionVO getSystemSelection(String selectionKey) {
        PrdSystemSelectionVO prdSystemSelectionVO = this.systemSelectionCacheMap.get(selectionKey);
        if (prdSystemSelectionVO == null && this.shouldLoadCache(lastLoadTimeSystemSelection)) {
            this.loadSystemSelectionCache();
            return this.systemSelectionCacheMap.get(selectionKey);
        }
        return prdSystemSelectionVO;
    }

    public void loadSystemSettingCache() {
        this.systemSettingCacheMap.clear();
        PrdSystemSettingQuery query = new PrdSystemSettingQuery();
        List<PrdSystemSettingVO> systemSettingViews = this.prdSystemSettingDAO.queryListDynamic(query);
        systemSettingViews.forEach(systemSettingView -> this.systemSettingCacheMap.put(systemSettingView.getSettingKey(), (PrdSystemSettingVO)systemSettingView));
        lastLoadTimeSystemSetting = new Date().getTime();
    }

    public PrdSystemSettingVO getSystemSetting(String settingKey) {
        PrdSystemSettingVO systemSettingView = this.systemSettingCacheMap.get(settingKey);
        if (systemSettingView == null && this.shouldLoadCache(lastLoadTimeSystemSetting)) {
            this.loadSystemSettingCache();
            return this.systemSettingCacheMap.get(settingKey);
        }
        return systemSettingView;
    }

    public String getUserName(Long userId) {
        if (userId == null) {
            return "";
        }
        PrdOrgEmployeeVO employeeVO = this.employeeCacheMap.get(userId);
        if (employeeVO == null) {
            PrdOrgEmployeeDO prdOrgEmployeeDO = this.employeeDAO.queryByUserId(userId);
            if (prdOrgEmployeeDO == null) {
                return null;
            }
            this.employeeCacheMap.put(userId, PrdOrgEmployeeConvert.INSTANCE.toVo(prdOrgEmployeeDO));
            employeeVO = this.employeeCacheMap.get(userId);
        }
        return employeeVO.getEmployeeName();
    }

    public String getUserMobile(Long userId) {
        if (userId == null) {
            return "";
        }
        String key = "EMPLOYEES_CACHE_MOBILE_KEY:" + userId;
        String cacheValue = (String)this.redisUtils.get(key);
        if (cacheValue == null) {
            String phoneByUserId = this.employeeDAO.getPhoneByUserId(userId);
            if (null == phoneByUserId) {
                return null;
            }
            this.redisUtils.set(key, phoneByUserId, 10L, TimeUnit.MINUTES);
            return phoneByUserId;
        }
        return cacheValue;
    }

    public Long getUserIdByName(String employeeName) {
        String key = "EMPLOYEES_CACHE_KEY:" + employeeName;
        PrdOrgEmployeeVO vo = (PrdOrgEmployeeVO)this.redisUtils.get(key);
        if (vo == null) {
            PrdOrgEmployeeDO employeeDO = this.employeeDAO.queryByUserName(employeeName);
            if (employeeDO == null) {
                return null;
            }
            PrdOrgEmployeeVO orgEmployeeVO = PrdOrgEmployeeConvert.INSTANCE.toVo(employeeDO);
            this.redisUtils.set(key, orgEmployeeVO, 10L, TimeUnit.MINUTES);
            return orgEmployeeVO.getUserId();
        }
        return vo.getUserId();
    }

    public Long getDefaultOrgIdByUserId(Long userId) {
        List list;
        List<PrdOrgDataRefVO> prdOrgDataRefVOS;
        if (null == userId) {
            return null;
        }
        String key = "EMPLOYEES_ORGANIZATION_CACHE_KEY:" + userId;
        Long orgId = (Long)this.redisUtils.get(key);
        if (orgId == null && !org.springframework.util.CollectionUtils.isEmpty(prdOrgDataRefVOS = this.prdUserDAO.queryOrgListByKey(userId)) && !org.springframework.util.CollectionUtils.isEmpty(list = prdOrgDataRefVOS.stream().filter(prdOrgDataRefVO -> prdOrgDataRefVO.getIsDefault().equals(0)).collect(Collectors.toList()))) {
            Long orgIdDb = ((PrdOrgDataRefVO)list.get(0)).getOrgId();
            if (null == orgIdDb) {
                return null;
            }
            this.redisUtils.set(key, orgIdDb, 10L, TimeUnit.MINUTES);
            return orgIdDb;
        }
        return orgId;
    }

    public List<Long> getManagerOrgIdsByUserId(Long userId) {
        List<PrdOrgOrganizationDO> organizationDOList;
        if (null == userId) {
            return null;
        }
        String key = "EMPLOYEES_MANAGER_ORG_KEY:" + userId;
        List orgIds = (List)this.redisUtils.get(key);
        if (ObjectUtils.isEmpty((Object)orgIds) && !org.springframework.util.CollectionUtils.isEmpty(organizationDOList = this.orgOrganizationDAO.queryByManagerId(userId))) {
            List<Long> orgIdList = organizationDOList.stream().map(BaseModel::getId).collect(Collectors.toList());
            this.redisUtils.set(key, orgIdList, 10L, TimeUnit.MINUTES);
            return orgIdList;
        }
        return orgIds;
    }

    public List<Long> getMyOrgIdsByUserId(Long userId) {
        List<Long> longs;
        if (null == userId) {
            return null;
        }
        String key = "EMPLOYEES_MY_ORG_KEY:" + userId;
        List orgIds = (List)this.redisUtils.get(key);
        if (ObjectUtils.isEmpty((Object)orgIds) && !org.springframework.util.CollectionUtils.isEmpty(longs = this.orgOrganizationDAO.queryOrgIdSByKey(userId))) {
            this.redisUtils.set(key, longs, 10L, TimeUnit.MINUTES);
            return longs;
        }
        return orgIds;
    }

    public PrdOrgDataRefVO getDefaultOrgInfoByUserId(Long userId) {
        List list;
        List<PrdOrgDataRefVO> prdOrgDataRefVOS;
        if (null == userId) {
            return null;
        }
        String key = "EMPLOYEES_DEFAULT_ORGANIZATION_INFO_CACHE_KEY:" + userId;
        PrdOrgDataRefVO result = (PrdOrgDataRefVO)this.redisUtils.get(key);
        if (result == null && !org.springframework.util.CollectionUtils.isEmpty(prdOrgDataRefVOS = this.prdUserDAO.queryOrgListByKey(userId)) && !org.springframework.util.CollectionUtils.isEmpty(list = prdOrgDataRefVOS.stream().filter(prdOrgDataRefVO -> prdOrgDataRefVO.getIsDefault().equals(0)).collect(Collectors.toList()))) {
            PrdOrgDataRefVO prdOrgDataRefVO2 = (PrdOrgDataRefVO)list.get(0);
            if (null == prdOrgDataRefVO2) {
                return null;
            }
            this.redisUtils.set(key, prdOrgDataRefVO2, 10L, TimeUnit.MINUTES);
            return prdOrgDataRefVO2;
        }
        return result;
    }

    public String getOrgName(Long ordId) {
        if (ordId == null) {
            return "";
        }
        String key = "ORGANIZATION_CACHE_KEY:" + ordId;
        PrdOrgOrganizationVO vo = (PrdOrgOrganizationVO)this.redisUtils.get(key);
        if (vo == null) {
            PrdOrgOrganizationDO prdOrgOrganizationDO = this.orgOrganizationDAO.queryById(ordId);
            if (prdOrgOrganizationDO == null) {
                return null;
            }
            PrdOrgOrganizationVO prdOrgOrganizationVO = PrdOrgOrganizationConvert.INSTANCE.toVo(prdOrgOrganizationDO);
            this.redisUtils.set(key, prdOrgOrganizationVO, 10L, TimeUnit.MINUTES);
            return prdOrgOrganizationVO.getOrgName();
        }
        return vo.getOrgName();
    }

    public Long getOrgManageUserId(Long ordId) {
        if (ordId == null) {
            return 0L;
        }
        String key = "ORGANIZATION_CACHE_KEY:" + ordId;
        PrdOrgOrganizationVO vo = (PrdOrgOrganizationVO)this.redisUtils.get(key);
        if (vo == null) {
            PrdOrgOrganizationDO prdOrgOrganizationDO = this.orgOrganizationDAO.queryById(ordId);
            if (prdOrgOrganizationDO == null) {
                return null;
            }
            PrdOrgOrganizationVO prdOrgOrganizationVO = PrdOrgOrganizationConvert.INSTANCE.toVo(prdOrgOrganizationDO);
            this.redisUtils.set(key, prdOrgOrganizationVO, 10L, TimeUnit.MINUTES);
            return prdOrgOrganizationVO.getManageId();
        }
        return vo.getManageId();
    }

    public List<Long> getSubordinatesByManageUserId(Long userId) {
        String key = "EMPLOYEES_MANAGER_SUBORDINATES_KEY:" + userId;
        List resultCache = (List)this.redisUtils.get(key);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)resultCache)) {
            List<Long> subordinateCollection;
            PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = this.employeeDAO.queryUserOrgData(userId);
            if (prdOrgEmployeeRefVO != null && prdOrgEmployeeRefVO.getManageId() != null && userId.equals(prdOrgEmployeeRefVO.getManageId())) {
                Long orgId = prdOrgEmployeeRefVO.getOrgId();
                List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = this.orgOrganizationDAO.queryEmployeeList(orgId);
                subordinateCollection = prdOrgEmployeeRefVOS.stream().map(e -> e.getUserId()).distinct().collect(Collectors.toList());
            } else {
                subordinateCollection = Collections.singletonList(userId);
            }
            this.redisUtils.set(key, subordinateCollection, 10L, TimeUnit.MINUTES);
            return subordinateCollection;
        }
        return resultCache;
    }

    public Long getOrgIdByOrgName(String orgName) {
        String key = "ORGANIZATION_CACHE_KEY:" + orgName;
        PrdOrgOrganizationVO vo = (PrdOrgOrganizationVO)this.redisUtils.get(key);
        if (vo == null) {
            PrdOrgOrganizationDO prdOrgOrganizationDO = this.orgOrganizationDAO.queryByName(orgName);
            if (prdOrgOrganizationDO == null) {
                return null;
            }
            PrdOrgOrganizationVO prdOrgOrganizationVO = PrdOrgOrganizationConvert.INSTANCE.toVo(prdOrgOrganizationDO);
            this.redisUtils.set(key, prdOrgOrganizationVO, 10L, TimeUnit.MINUTES);
            return prdOrgOrganizationVO.getId();
        }
        return vo.getId();
    }

    public PrdOrgEmployeeVO getEmployee(Long userId) {
        PrdOrgEmployeeVO employeeVO = this.employeeCacheMap.get(userId);
        if (employeeVO == null) {
            PrdOrgEmployeeDO prdOrgEmployeeDO = this.employeeDAO.queryByUserId(userId);
            if (prdOrgEmployeeDO == null) {
                return null;
            }
            this.employeeCacheMap.put(userId, PrdOrgEmployeeConvert.INSTANCE.toVo(prdOrgEmployeeDO));
            employeeVO = this.employeeCacheMap.get(userId);
        }
        return employeeVO;
    }

    public Boolean hasSystemRolePermission(List<String> roleList) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        String longString = this.userRoleMaps.get(loginUserId);
        if (!StringUtils.hasText((String)longString) || this.shouldLoadCache(Long.valueOf(longString.split(",")[0]))) {
            this.loadSystemRoleCache(loginUserId);
            return this.hasSystemRolePermission(roleList);
        }
        List<String> stringList = Arrays.asList(longString.split(","));
        for (String roleCode : roleList) {
            if (!stringList.contains(roleCode)) continue;
            return true;
        }
        return false;
    }

    public List<Long> queryRoleUserIds(String roleCode) {
        List<Long> longs = this.roleUserMaps.get(roleCode);
        if (ObjectUtils.isEmpty(longs) || this.shouldLoadCache(lastLoadTimeSystemRole)) {
            this.loadSystemRoleCache(roleCode);
            return this.roleUserMaps.get(roleCode);
        }
        return longs;
    }

    public void loadSystemRoleCache(String roleCode) {
        List<Long> userIds = this.systemRoleDAO.queryUserIdByRoleCode(roleCode);
        this.roleUserMaps.put(roleCode, userIds);
        lastLoadTimeSystemSetting = new Date().getTime();
    }

    public List<String> getSystemRoleCodes(Long userId) {
        if (null == userId) {
            userId = GlobalUtil.getLoginUserId();
        }
        List<String> roleCodes = this.systemRoleDAO.queryUserRoleCodes(userId);
        return roleCodes;
    }

    public List<String> getSystemRoleCodesCache(Long userId) {
        String roleCodesStr;
        if (null == userId) {
            userId = GlobalUtil.getLoginUserId();
        }
        if (!StringUtils.hasText((String)(roleCodesStr = this.userRoleMaps.get(userId))) || this.shouldLoadCache(Long.valueOf(roleCodesStr.split(",")[0]))) {
            this.loadSystemRoleCache(userId);
            roleCodesStr = this.userRoleMaps.get(userId);
        }
        if (StringUtils.hasText((String)roleCodesStr)) {
            List<String> roleCodes = Arrays.asList(roleCodesStr.split(","));
            return roleCodes;
        }
        return new ArrayList<String>();
    }

    public void loadSystemRoleCache(Long loginUserId) {
        List<String> roleCodes = this.systemRoleDAO.queryUserRoleCodes(loginUserId);
        Object str = "" + new Date().getTime();
        if (!ObjectUtils.isEmpty(roleCodes)) {
            str = ((String)str).concat(",").concat(StringUtils.collectionToCommaDelimitedString(roleCodes));
        }
        this.userRoleMaps.put(loginUserId, (String)str);
    }

    public CacheUtil(PrdSystemRemindDAO systemRemindDAO, PrdSystemSelectionDAO prdSystemSelectionDAO, PrdSystemTagDAO prdSystemTagDAO, PrdSystemSettingDAO prdSystemSettingDAO, RedisUtils redisUtils, PrdSystemFunctionDAO prdSystemFunctionDAO, PrdSystemFunctionSpecialDAO prdSystemFunctionSpecialDAO, PrdSystemFunctionDataDAO prdSystemFunctionDataDAO, PrdSystemConfigDAO prdSystemConfigDAO, PrdOrgEmployeeDAO employeeDAO, PrdOrgOrganizationDAO orgOrganizationDAO, PrdSystemRoleDAO systemRoleDAO, PrdUserDAO prdUserDAO) {
        this.systemRemindDAO = systemRemindDAO;
        this.prdSystemSelectionDAO = prdSystemSelectionDAO;
        this.prdSystemTagDAO = prdSystemTagDAO;
        this.prdSystemSettingDAO = prdSystemSettingDAO;
        this.redisUtils = redisUtils;
        this.prdSystemFunctionDAO = prdSystemFunctionDAO;
        this.prdSystemFunctionSpecialDAO = prdSystemFunctionSpecialDAO;
        this.prdSystemFunctionDataDAO = prdSystemFunctionDataDAO;
        this.prdSystemConfigDAO = prdSystemConfigDAO;
        this.employeeDAO = employeeDAO;
        this.orgOrganizationDAO = orgOrganizationDAO;
        this.systemRoleDAO = systemRoleDAO;
        this.prdUserDAO = prdUserDAO;
    }
}

