/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.common;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFunctionSpecialVO;
import com.elitesland.tw.tw5.server.common.NotOnlineException;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.configurationprocessor.json.JSONException;
import org.springframework.boot.configurationprocessor.json.JSONObject;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class GlobalUtil {
    private final CacheUtil cacheUtil;
    public static final ObjectMapper objectMapper = new ObjectMapper();

    public static Long getTenantId() {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (user == null) {
            throw NotOnlineException.error("", "\u83b7\u53d6\u7528\u6237\u6570\u636e\u5931\u8d25");
        }
        return user.getUser().getTenantId();
    }

    public static SysUserDTO getLoginUser() {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (user == null) {
            throw NotOnlineException.error("", "\u83b7\u53d6\u7528\u6237\u6570\u636e\u5931\u8d25");
        }
        return user.getUser();
    }

    public static GeneralUserDetails getLoginGeneralUser() {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (user == null) {
            throw NotOnlineException.error("", "\u83b7\u53d6\u7528\u6237\u6570\u636e\u5931\u8d25");
        }
        return user;
    }

    public static Long getLoginUserId() {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (user == null) {
            throw NotOnlineException.error("", "\u83b7\u53d6\u7528\u6237\u6570\u636e\u5931\u8d25");
        }
        return user.getUser().getId();
    }

    public static String getLoginUserName() {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (user == null) {
            throw NotOnlineException.error("", "\u83b7\u53d6\u7528\u6237\u6570\u636e\u5931\u8d25");
        }
        String firstName = user.getUser().getFirstName();
        if (!StringUtils.hasText((String)firstName)) {
            firstName = user.getUser().getLastName();
        }
        return firstName;
    }

    public List<String> getSystemRoleCodesCache(Long userId) {
        return this.cacheUtil.getSystemRoleCodesCache(userId);
    }

    public List<String> getSystemRoleCodes(Long userId) {
        return this.cacheUtil.getSystemRoleCodes(userId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkOperateUrl(String url) throws JSONException {
        PrdSystemFunctionSpecialVO vo = this.cacheUtil.getFunctionSpecial(url);
        if (vo == null) return true;
        String roles = vo.getSpecialRoles();
        if (roles == null || roles == "") return true;
        JSONObject jsonObject = new JSONObject().getJSONObject(roles);
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (userDetails == null) return false;
        SysUserDTO user = userDetails.getUser();
        Long userId = user.getId();
        if (jsonObject.getString("1").contains("" + userId)) {
            return true;
        }
        String rolesStr = jsonObject.getString("2");
        List userRoles = user.getRoles();
        for (IdCodeNameParam role : userRoles) {
            if (!rolesStr.contains("" + role.getId())) continue;
            return true;
        }
        return false;
    }

    public static <T> void mergeObject(T origin, T destination) {
        if (origin == null || destination == null) {
            return;
        }
        if (!origin.getClass().equals(destination.getClass())) {
            return;
        }
        Field[] fields = origin.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                fields[i].setAccessible(true);
                Object value = fields[i].get(origin);
                if (null != value) {
                    fields[i].set(destination, value);
                }
                fields[i].setAccessible(false);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean checkDeletePermission(String url) throws JSONException {
        return true;
    }

    public boolean checkLookPermission(String url) throws JSONException {
        return true;
    }

    Object getFileValue(String fieldName, Object object) {
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void responseJson(HttpServletResponse response) {
        try {
            String json = GlobalUtil.getJson(TwOutputUtil.ok());
            response.getWriter().write(json);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getJson(Object obj) {
        String json = null;
        try {
            json = objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return json;
    }

    public static String stringHtmlFilter(String str) throws PatternSyntaxException {
        String regEx = "(?!<(br|a|/a).*?>)<.*?>";
        Pattern p_html = Pattern.compile(regEx, 2);
        Matcher m_html = p_html.matcher(str);
        str = m_html.replaceAll("");
        return str;
    }

    public static String getContantsLog(String detail, String oldName, String newName, String oldPhone, String newPhone) {
        if (newName != null) {
            if (oldName == null && newName != null) {
                detail = (String)detail + " \u8054\u7cfb\u4eba\u7531 - \u4fee\u6539\u4e3a " + newName;
            } else if (!newName.equals(oldName)) {
                detail = (String)detail + " \u8054\u7cfb\u4eba\u7531 " + oldName + " \u4fee\u6539\u4e3a " + newName;
            }
        }
        if (newPhone != null) {
            if (oldPhone == null && newPhone != null) {
                detail = (String)detail + " \u8054\u7cfb\u4eba\u7535\u8bdd\u7531 - \u4fee\u6539\u4e3a " + newPhone;
            } else if (!newPhone.equals(oldPhone)) {
                detail = (String)detail + " \u8054\u7cfb\u4eba\u7535\u8bdd\u7531 " + oldPhone + " \u4fee\u6539\u4e3a " + newPhone;
            }
        }
        return detail;
    }

    public static <T> List<List<T>> splistList(List<T> list, int subNum) {
        ArrayList<List<T>> tNewList = new ArrayList<List<T>>();
        int priIndex = 0;
        int lastPriIndex = 0;
        int insertTimes = list.size() / subNum;
        List<Object> subList = new ArrayList();
        for (int i = 0; i <= insertTimes; ++i) {
            priIndex = subNum * i;
            lastPriIndex = priIndex + subNum;
            subList = i == insertTimes ? list.subList(priIndex, list.size()) : list.subList(priIndex, lastPriIndex);
            if (subList.size() <= 0) continue;
            tNewList.add(subList);
        }
        return tNewList;
    }

    public GlobalUtil(CacheUtil cacheUtil) {
        this.cacheUtil = cacheUtil;
    }
}

