/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.file.service;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.file.payload.PrdFilePayload;
import com.elitesland.tw.tw5.api.prd.file.query.PrdFileQuery;
import com.elitesland.tw.tw5.api.prd.file.service.PrdFileService;
import com.elitesland.tw.tw5.api.prd.file.vo.PrdFileVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.FileUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.file.config.FileProperties;
import com.elitesland.tw.tw5.server.prd.file.convert.PrdFileConvert;
import com.elitesland.tw.tw5.server.prd.file.entity.PrdFileDO;
import com.elitesland.tw.tw5.server.prd.file.repo.PrdFileRepo;
import com.elitesland.tw.tw5.server.prd.office.storage.FileStorageMutator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class PrdFileLocalServiceImpl
implements PrdFileService {
    private static final Logger log = LoggerFactory.getLogger(PrdFileLocalServiceImpl.class);
    private final FileProperties fileProperties;
    private final PrdSystemLogService logService;
    private final PrdFileRepo prdFileRepo;
    private final FileStorageMutator storageMutator;

    public PrdFileVO upload(String name, Long folderId, MultipartFile multipartFile) {
        if (null == folderId) {
            folderId = 1L;
        }
        String originalFilename = multipartFile.getOriginalFilename();
        long fileSize = multipartFile.getSize();
        FileUtil.checkSize(this.fileProperties.getMaxSize(), fileSize);
        String suffix = FileUtil.getExtensionName(multipartFile.getOriginalFilename());
        String type = FileUtil.getFileType(suffix);
        File file = FileUtil.upload(multipartFile, this.fileProperties.getPath().getPath() + type + File.separator);
        if (ObjectUtil.isNull((Object)file)) {
            throw TwException.error("0802", "\u4e0a\u4f20\u5931\u8d25");
        }
        try {
            name = StringUtils.isBlank((CharSequence)name) ? FileUtil.getFileNameNoEx(multipartFile.getOriginalFilename()) : name;
            PrdFileDO entityDo = new PrdFileDO();
            entityDo.setName(name);
            entityDo.setFolderId(folderId);
            entityDo.setFileName(originalFilename);
            entityDo.setRealName(file.getName());
            entityDo.setServerPath(file.getPath());
            entityDo.setSuffix(suffix);
            entityDo.setFileType(multipartFile.getContentType());
            entityDo.setFileTypeDesc(type);
            entityDo.setFileSize(fileSize);
            entityDo.setFileSizeDesc(FileUtil.getSize(fileSize));
            return PrdFileConvert.INSTANCE.toVo((PrdFileDO)this.prdFileRepo.save(entityDo));
        }
        catch (Exception e) {
            FileUtil.del((File)file);
            throw e;
        }
    }

    public PrdFileVO createByContractTemp(String name, Long folderId) throws IOException {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw TwException.error("", "name is empty");
        }
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddhhmmssS");
        String nowStr = "-" + format.format(date);
        String pathStr = this.fileProperties.getPath().getPath() + "\u6587\u6863" + File.separator;
        String suffix = ".docx";
        String fileName = name + ".docx";
        String fileNamePro = name + nowStr + ".docx";
        String fileNamePath = pathStr + fileNamePro;
        log.info("[file] fileNamePath:{}", (Object)fileNamePath);
        if (null == folderId) {
            folderId = 1L;
        }
        String demoPath = "assets" + File.separator + "new.docx";
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(demoPath);
        if (stream == null) {
            log.error("[file] \u6a21\u677fnew.docx\u6587\u4ef6\u4e0d\u5b58\u5728");
            return null;
        }
        Path path = Path.of(fileNamePath, new String[0]);
        this.storageMutator.createFile(path, stream);
        String originalFilename = fileName;
        PrdFileDO entityDo = new PrdFileDO();
        entityDo.setName(name);
        entityDo.setFolderId(folderId);
        entityDo.setFileName(originalFilename);
        entityDo.setRealName(fileName);
        entityDo.setServerPath(fileNamePath);
        entityDo.setSuffix("docx");
        String fileType = Files.probeContentType(path);
        entityDo.setFileType(fileType);
        entityDo.setFileTypeDesc("\u6587\u6863");
        long fileSize = Files.size(path);
        entityDo.setFileSize(fileSize);
        entityDo.setFileSizeDesc(FileUtil.getSize(fileSize));
        return PrdFileConvert.INSTANCE.toVo((PrdFileDO)this.prdFileRepo.save(entityDo));
    }

    public String getFilePath(String type) {
        return this.fileProperties.getPath().getPath() + type + File.separator;
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdFileVO insert(PrdFilePayload payload) {
        PrdFileDO entityDo = PrdFileConvert.INSTANCE.toDo(payload);
        this.prdFileRepo.save(entityDo);
        return PrdFileConvert.INSTANCE.toVo(entityDo);
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdFileVO update(PrdFilePayload payload) {
        PrdFileDO entity = this.prdFileRepo.findById(payload.getId()).orElseGet(PrdFileDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u9644\u4ef6\u4e0d\u5b58\u5728");
        PrdFileDO entityDo = PrdFileConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PrdFileConvert.INSTANCE.toVo((PrdFileDO)this.prdFileRepo.save(entity));
    }

    public PrdFileVO queryByKey(Long key) {
        PrdFileDO entity = this.prdFileRepo.findById(key).orElseGet(PrdFileDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u9644\u4ef6\u4e0d\u5b58\u5728");
        return PrdFileConvert.INSTANCE.toVo(entity);
    }

    public List<PrdFileVO> queryList(PrdFileQuery query) {
        return PrdFileConvert.INSTANCE.toVoList(this.prdFileRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    public PagingVO<PrdFileVO> paging(PrdFileQuery query) {
        OrderItem orderItem = OrderItem.desc((String)"createTime");
        query.defaultOrder(orderItem);
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder);
        Page page = this.prdFileRepo.findAll(specification, (Pageable)query.getPageRequest());
        return PageUtil.toPageVo(page.map(PrdFileConvert.INSTANCE::toVo));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.prdFileRepo.findById(id);
                if (!optional.isEmpty()) {
                    PrdFileDO entity = (PrdFileDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.prdFileRepo.save(entity);
                }
            });
        }
    }

    public PrdFileLocalServiceImpl(FileProperties fileProperties, PrdSystemLogService logService, PrdFileRepo prdFileRepo, FileStorageMutator storageMutator) {
        this.fileProperties = fileProperties;
        this.logService = logService;
        this.prdFileRepo = prdFileRepo;
        this.storageMutator = storageMutator;
    }
}

