/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemTagPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemTagQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemTagService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemTagVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemTagConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemTagDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemTagDO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PrdSystemTagServiceImpl
implements PrdSystemTagService {
    private static final Logger log = LoggerFactory.getLogger(PrdSystemTagServiceImpl.class);
    private final PrdSystemTagDAO dao;
    private final CacheUtil cacheUtil;

    @Transactional
    public PrdSystemTagVO insert(PrdSystemTagPayload payload) {
        payload.setTagKey(payload.getTagKey().trim());
        PrdSystemTagQuery query = new PrdSystemTagQuery();
        query.setTagKey(payload.getTagKey());
        int count = this.dao.queryListDynamic(query).size();
        if (count > 0) {
            throw TwException.error("", "\u7f16\u53f7\u4e0d\u53ef\u91cd\u590d");
        }
        PrdSystemTagDO ado = PrdSystemTagConvert.INSTANCE.toDo(payload);
        this.dao.save(ado);
        this.cacheUtil.loadSystemTagCache();
        return PrdSystemTagConvert.INSTANCE.toVo(ado);
    }

    @Transactional
    public Long update(PrdSystemTagPayload payload) {
        if (payload.getTagKey() != null) {
            payload.setTagKey(payload.getTagKey().trim());
            PrdSystemTagQuery query = new PrdSystemTagQuery();
            query.setTagKey(payload.getTagKey());
            query.setId(payload.getId());
            int count = this.dao.queryListDynamic(query).size();
            if (count > 0) {
                throw TwException.error("", "\u7f16\u53f7\u4e0d\u53ef\u91cd\u590d");
            }
        }
        this.dao.updateByKeyDynamic(payload);
        this.cacheUtil.loadSystemTagCache();
        return 0L;
    }

    @Transactional
    public boolean delete(List<Long> keys) {
        this.dao.delete(keys);
        this.cacheUtil.loadSystemTagCache();
        return true;
    }

    @Transactional
    public boolean deleteSoft(List<Long> keys) {
        this.dao.deleteSoft(keys);
        this.cacheUtil.loadSystemTagCache();
        return true;
    }

    public PrdSystemTagVO queryByKey(Long key) {
        return this.dao.queryByKey(key);
    }

    public PagingVO<PrdSystemTagVO> paging(PrdSystemTagQuery query) {
        return this.dao.queryPaging(query);
    }

    public void clearCache() {
        this.cacheUtil.loadSystemTagCache();
    }

    public List<PrdSystemTagVO> queryList(PrdSystemTagQuery query) {
        ArrayList<PrdSystemTagVO> tagVOS = new ArrayList<PrdSystemTagVO>();
        this.cacheUtil.getSystemTag(null).forEach(tagVO -> {
            boolean isData = tagVO.getEnabled();
            if (isData && query.getFunctionId() != null && query.getFunctionId().longValue() != tagVO.getFunctionId().longValue()) {
                isData = false;
            }
            if (isData && query.getSceneNo() != null && !query.getSceneNo().equals(tagVO.getSceneNo())) {
                isData = false;
            }
            if (isData && query.getTagColor() != null && !query.getTagColor().equals(tagVO.getTagColor())) {
                isData = false;
            }
            if (isData) {
                tagVOS.add((PrdSystemTagVO)tagVO);
            }
        });
        return tagVOS;
    }

    public PrdSystemTagServiceImpl(PrdSystemTagDAO dao, CacheUtil cacheUtil) {
        this.dao = dao;
        this.cacheUtil = cacheUtil;
    }
}

