/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.tenant.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.tenant.payload.AuthTenantPayload;
import com.elitesland.tw.tw5.api.tenant.query.AuthTenantQuery;
import com.elitesland.tw.tw5.api.tenant.vo.AuthTenantVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.tenant.entity.AuthTenantDO;
import com.elitesland.tw.tw5.server.tenant.entity.QAuthTenantDO;
import com.elitesland.tw.tw5.server.tenant.repo.AuthTenantRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class AuthTenantDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final AuthTenantRepo repo;
    private final QAuthTenantDO qdo = QAuthTenantDO.authTenantDO;

    private JPAQuery<AuthTenantVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(AuthTenantVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.authTenantId, this.qdo.authType})).from((EntityPath)this.qdo);
    }

    private JPAQuery<AuthTenantVO> getJpaQueryWhere(AuthTenantQuery query) {
        JPAQuery<AuthTenantVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(AuthTenantQuery query) {
        long total = (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).where(this.where(query))).fetchOne();
        return total;
    }

    private Predicate where(AuthTenantQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAuthTenantId())) {
            list.add(this.qdo.authTenantId.eq((Object)query.getAuthTenantId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAuthType())) {
            list.add(this.qdo.authType.eq((Object)query.getAuthType()));
        }
        return ExpressionUtils.allOf(list);
    }

    public AuthTenantVO queryByKey(Long id) {
        JPAQuery<AuthTenantVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (AuthTenantVO)jpaQuery.fetchFirst();
    }

    public List<AuthTenantVO> queryListDynamic(AuthTenantQuery query) {
        JPAQuery<AuthTenantVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<AuthTenantVO> queryPaging(AuthTenantQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<AuthTenantVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public AuthTenantDO save(AuthTenantDO ado) {
        return (AuthTenantDO)this.repo.save(ado);
    }

    public List<AuthTenantDO> saveAll(List<AuthTenantDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(AuthTenantPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getAuthTenantId() != null) {
            update.set(this.qdo.authTenantId, (Object)payload.getAuthTenantId());
        }
        if (payload.getAuthType() != null) {
            update.set((Path)this.qdo.authType, (Object)payload.getAuthType());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("authTenantId")) {
                update.setNull(this.qdo.authTenantId);
            }
            if (nullFields.contains("authType")) {
                update.setNull((Path)this.qdo.authType);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public AuthTenantDAO(JPAQueryFactory jpaQueryFactory, AuthTenantRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

