/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common;

import com.elitesland.tw.tw5.server.common.TwMessage;
import java.util.ArrayList;
import java.util.List;

public class TwException
extends RuntimeException {
    private String code;
    private Object data;
    private List<TwMessage> warns = new ArrayList<TwMessage>();
    private List<TwMessage> errors = new ArrayList<TwMessage>();

    private TwException() {
    }

    public static TwException exception(String code) {
        TwException exception = new TwException();
        exception.code = code;
        return exception;
    }

    public static TwException error(String code, String msg) {
        TwException exception = new TwException();
        exception.code = code;
        exception.errors.add(TwMessage.of(msg));
        return exception;
    }

    public static TwException warn(String code, String msg) {
        TwException exception = new TwException();
        exception.code = code;
        exception.errors.add(TwMessage.of(msg));
        return exception;
    }

    public static TwException error(String code, String localeCode, String defaultMsg, Object data) {
        TwException exception = new TwException();
        exception.code = code;
        exception.errors.add(TwMessage.of(localeCode, defaultMsg, data));
        return exception;
    }

    public static TwException warn(String code, String localeCode, String defaultMsg, Object data) {
        TwException exception = new TwException();
        exception.code = code;
        exception.warns.add(TwMessage.of(localeCode, defaultMsg, data));
        return exception;
    }

    public TwException addError(String msg) {
        this.errors.add(TwMessage.of(msg));
        return this;
    }

    public TwException addError(String localeCode, String defaultMsg, Object data) {
        this.errors.add(TwMessage.of(localeCode, defaultMsg, data));
        return this;
    }

    public TwException addWarn(String msg) {
        this.warns.add(TwMessage.of(msg));
        return this;
    }

    public TwException addWarn(String localeCode, String defaultMsg, Object data) {
        this.warns.add(TwMessage.of(localeCode, defaultMsg, data));
        return this;
    }

    public String getCode() {
        return this.code;
    }

    public Object getData() {
        return this.data;
    }

    public List<TwMessage> getWarns() {
        return this.warns;
    }

    public List<TwMessage> getErrors() {
        return this.errors;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public void setWarns(List<TwMessage> warns) {
        this.warns = warns;
    }

    public void setErrors(List<TwMessage> errors) {
        this.errors = errors;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TwException)) {
            return false;
        }
        TwException other = (TwException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        Object this$data = this.getData();
        Object other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        List<TwMessage> this$warns = this.getWarns();
        List<TwMessage> other$warns = other.getWarns();
        if (this$warns == null ? other$warns != null : !((Object)this$warns).equals(other$warns)) {
            return false;
        }
        List<TwMessage> this$errors = this.getErrors();
        List<TwMessage> other$errors = other.getErrors();
        return !(this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TwException;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        Object $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        List<TwMessage> $warns = this.getWarns();
        result = result * 59 + ($warns == null ? 43 : ((Object)$warns).hashCode());
        List<TwMessage> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "TwException(code=" + this.getCode() + ", data=" + this.getData() + ", warns=" + this.getWarns() + ", errors=" + this.getErrors() + ")";
    }
}

