/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.ab.service.PrdAbAddressService;
import com.elitesland.tw.tw5.api.prd.ab.vo.PrdAbVO;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmLeadsQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmLeadsService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmLeadsListVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityVO;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.dao.TransferUtilDAO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmCustomerDAO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class BusinessFollowServiceImpl {
    private final CacheUtil cacheUtil;
    private final TransferUtilDAO dao;
    private final CrmCustomerDAO daoCustomer;
    private final CrmLeadsService leadService;
    private final PrdAbAddressService serviceAbAddress;
    private final CrmOpportunityService opportunityService;
    private final HttpUtil httpUtil;

    public PagingVO<CrmLeadsListVO> queryLeadsFollow(TwQueryParam query, Long customerId) {
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.PLATFORM_RES.getCode(), RoleEnum.CUST_OPER_MANAGER.getCode()));
        CrmLeadsQuery leadsQuery = new CrmLeadsQuery();
        leadsQuery.setCurrent(query.getCurrent());
        leadsQuery.setSize(query.getSize());
        leadsQuery.setFormalCustomerId(customerId);
        leadsQuery.setIsPermission(Boolean.valueOf(rolePermission == false));
        return this.leadService.paging(leadsQuery);
    }

    public PagingVO<CrmOpportunityVO> queryOppoFollow(TwQueryParam query, Long customerId) {
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.PLATFORM_RES.getCode(), RoleEnum.CUST_OPER_MANAGER.getCode()));
        CrmOpportunityQuery oppoQuery = new CrmOpportunityQuery();
        oppoQuery.setCurrent(query.getCurrent());
        oppoQuery.setSize(query.getSize());
        oppoQuery.setFormalCustomerId(customerId);
        oppoQuery.setIsPermission(Boolean.valueOf(rolePermission == false));
        return this.opportunityService.paging(oppoQuery);
    }

    public Object queryContractNum(Long customerId) {
        String url = "api/openReport/v1/sync/contractCount";
        PrdAbVO prdAbVO = this.daoCustomer.queryAbVOBykey(customerId);
        if (ObjectUtils.isEmpty((Object)prdAbVO)) {
            throw TwException.error("", "\u5173\u8054\u5ba2\u6237\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        return 0;
    }

    public Object queryProjectNum(Long customerId) {
        String url = "api/openReport/v1/sync/countProjectNumByCustId";
        PrdAbVO prdAbVO = this.daoCustomer.queryAbVOBykey(customerId);
        if (ObjectUtils.isEmpty((Object)prdAbVO)) {
            throw TwException.error("", "\u5173\u8054\u5ba2\u6237\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        return 0;
    }

    public Map<String, Object> queryContractFollow(TwQueryParam query, Long customerId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("total", 0);
        resultMap.put("records", new ArrayList());
        String url = "api/openReport/v1/sync/contract";
        PrdAbVO prdAbVO = this.daoCustomer.queryAbVOBykey(customerId);
        if (ObjectUtils.isEmpty((Object)prdAbVO)) {
            throw TwException.error("", "\u5173\u8054\u5ba2\u6237\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        return resultMap;
    }

    public BusinessFollowServiceImpl(CacheUtil cacheUtil, TransferUtilDAO dao, CrmCustomerDAO daoCustomer, CrmLeadsService leadService, PrdAbAddressService serviceAbAddress, CrmOpportunityService opportunityService, HttpUtil httpUtil) {
        this.cacheUtil = cacheUtil;
        this.dao = dao;
        this.daoCustomer = daoCustomer;
        this.leadService = leadService;
        this.serviceAbAddress = serviceAbAddress;
        this.opportunityService = opportunityService;
        this.httpUtil = httpUtil;
    }
}

