/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.demo.controller;

import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitesland.tw.tw5.api.demo.payload.DemoSimplePayload;
import com.elitesland.tw.tw5.api.demo.query.DemoSimpleQuery;
import com.elitesland.tw.tw5.api.demo.service.DemoSimpleService;
import com.elitesland.tw.tw5.api.demo.vo.DemoSimpleVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u7b80\u5355\u6837\u4f8b")
@RestController
@RequestMapping(value={"/api/demo"})
public class TwSimpleDemoController {
    private static final Logger log = LoggerFactory.getLogger(TwSimpleDemoController.class);
    private final DemoSimpleService service;

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/simple"})
    public TwOutputUtil insert(DemoSimplePayload payload) {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        this.service.insert(payload);
        return TwOutputUtil.ok(payload);
    }

    @ApiOperation(value="\u4fee\u6539")
    @PutMapping(value={"/simple"})
    public TwOutputUtil update(DemoSimplePayload payload) {
        this.service.update(payload);
        return TwOutputUtil.ok(payload);
    }

    @ApiOperation(value="\u4e3b\u952e\u67e5\u8be2")
    @GetMapping(value={"/simple/{key}"})
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        DemoSimpleVO vo = this.service.queryByKey(key);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"/simple/paging"})
    public TwOutputUtil paging(DemoSimpleQuery query) {
        PagingVO paging = this.service.paging(query);
        return TwOutputUtil.ok(paging);
    }

    @ApiOperation(value="\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/simple/list"})
    public TwOutputUtil queryList(DemoSimpleQuery query) {
        List vos = this.service.queryList(query);
        return TwOutputUtil.ok(vos);
    }

    @ApiOperation(value="\u5220\u9664")
    @PatchMapping(value={"/simple"})
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    public TwSimpleDemoController(DemoSimpleService service) {
        this.service = service;
    }
}

